"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const errors_1=require("./errors");function parseHexToInt(r){return!r.match(/[^a-f0-9]/i)?parseInt(r,16):NaN}function validateAndParseHex(r,e,o){const n=parseHexToInt(r);if(Number.isNaN(n)||void 0!==o&&o!==r.length)throw new SyntaxError(errors_1.errorMessages.get(e));return n}function parseHexadecimalCode(r){const e=validateAndParseHex(r,errors_1.ErrorType.MalformedHexadecimal,2);return String.fromCharCode(e)}function parseUnicodeCode(r,e){const o=validateAndParseHex(r,errors_1.ErrorType.MalformedUnicode,4);if(void 0!==e){const r=validateAndParseHex(e,errors_1.ErrorType.MalformedUnicode,4);return String.fromCharCode(o,r)}return String.fromCharCode(o)}function isCurlyBraced(r){return"{"===r.charAt(0)&&"}"===r.charAt(r.length-1)}function parseUnicodeCodePointCode(r){if(!isCurlyBraced(r))throw new SyntaxError(errors_1.errorMessages.get(errors_1.ErrorType.MalformedUnicode));const e=validateAndParseHex(r.slice(1,-1),errors_1.ErrorType.MalformedUnicode);try{return String.fromCodePoint(e)}catch(r){throw r instanceof RangeError?new SyntaxError(errors_1.errorMessages.get(errors_1.ErrorType.CodePointLimit)):r}}function parseOctalCode(r,e=!1){if(e)throw new SyntaxError(errors_1.errorMessages.get(errors_1.ErrorType.OctalDeprecation));const o=parseInt(r,8);return String.fromCharCode(o)}exports.ErrorType=errors_1.ErrorType,exports.errorMessages=errors_1.errorMessages;const singleCharacterEscapes=new Map([["b","\b"],["f","\f"],["n","\n"],["r","\r"],["t","\t"],["v","\v"],["0","\0"]]);function parseSingleCharacterCode(r){return singleCharacterEscapes.get(r)||r}const escapeMatch=/\\(?:(\\)|x([\s\S]{0,2})|u(\{[^}]*\}?)|u([\s\S]{4})\\u([^{][\s\S]{0,3})|u([\s\S]{0,4})|([0-3]?[0-7]{1,2})|([\s\S])|$)/g;function unraw(r,e=!1){return r.replace(escapeMatch,function(r,o,n,t,a,s,i,d,c){if(void 0!==o)return"\\";if(void 0!==n)return parseHexadecimalCode(n);if(void 0!==t)return parseUnicodeCodePointCode(t);if(void 0!==a)return parseUnicodeCode(a,s);if(void 0!==i)return parseUnicodeCode(i);if("0"===d)return"\0";if(void 0!==d)return parseOctalCode(d,!e);if(void 0!==c)return parseSingleCharacterCode(c);throw new SyntaxError(errors_1.errorMessages.get(errors_1.ErrorType.EndOfString))})}exports.unraw=unraw,exports.default=unraw;