"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const fs_1 = __importDefault(require("fs"));
const path_1 = __importDefault(require("path"));
const ejs_1 = __importDefault(require("ejs"));
const js_beautify_1 = __importDefault(require("js-beautify"));
const url_1 = require("url");
const compress_json_1 = require("compress-json");
const __filename = (0, url_1.fileURLToPath)(import.meta.url);
const __dirname = path_1.default.dirname(__filename);
var parsedApiDescription = (0, compress_json_1.decompress)(JSON.parse(fs_1.default.readFileSync(path_1.default.join(__dirname, './api.json'))));
const options = {};
const apiNameList = Object.keys(parsedApiDescription);
const mdContent = apiNameList.map(apiName => {
    console.log(apiName);
    console.log(parsedApiDescription[apiName]);
    parsedApiDescription[apiName].request = parsedApiDescription[apiName].request || { example: [{}] };
    const example = prepareExampleByApiDescription(parsedApiDescription[apiName], apiName);
    return `
### ${example.name} ([see docs](${example.docs}))
${example.description}

\`\`\`js
${example.code}
\`\`\`
`;
});
fs_1.default.writeFileSync('EXAMPLES.md', mdContent.join('\n'));
function prepareExampleByApiDescription(apiDescription, apiName) {
    function prepareUrl() {
        const sufix = apiName.replace(/\//g, '-');
        return `https://www.dropbox.com/developers/documentation/http/documentation#${sufix}`;
    }
    const templates = {
        'rpc': `
dropbox({
resource: '${apiName}'<% if(request.example[0].value) { %>,
parameters: <%- JSON.stringify(request.example[0].value, null, '') %> <% } %>}, (err, result, response) => {
    //see docs for \`result\` parameters
});
    `,
        'upload': `
        const stream = dropbox({
            resource: '${apiName}',
            parameters: <%- JSON.stringify(request.example[0].value, null, '') %>}, (err, result, response) => {
            //see docs for \`result\` parameters
        });

        fs.createReadStream(<%- request.example[0].value.path ? '\\''+request.example[0].value.path+'\\'': '' %>).pipe(stream);
    `,
        'download': `
        const stream = dropbox({
            resource: '${apiName}',
            parameters: <%- JSON.stringify(request.example[0].value, null, '') %>}, (err, result, response) => {
            //see docs for \`result\` parameters
        });

        stream
            .pipe(fs.createWriteStream(<%- request.example[0].value.path ? '\\''+request.example[0].value.path+'\\'': '' %>)); //pipe the stream
    `
    };
    const template = ejs_1.default.compile(templates[apiDescription.format], options);
    const code = js_beautify_1.default.js_beautify(template(apiDescription), { indent_size: 4 }).replace(/\"/g, '\'');
    return {
        docs: prepareUrl(),
        name: apiName,
        description: apiDescription.description,
        code
    };
}
