"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const request_1 = __importDefault(require("request"));
const fs_1 = __importDefault(require("fs"));
const compress_json_1 = __importDefault(require("compress-json"));
//-------------------------------------------
exports.default = generateApiDescription;
function generateApiDescription(cb) {
    return __awaiter(this, void 0, void 0, function* () {
        const NAMESPACES = ['account', 'auth', 'check', 'contacts', 'file_properties', 'file_requests', 'files', 'sharing', 'users'];
        let error = null;
        const apiExamples = {};
        try {
            for (let i = 0; i < NAMESPACES.length; i++) {
                const namespace = NAMESPACES[i];
                const endpoints = yield fetchNamespace(namespace);
                endpoints.forEach(endpoint => {
                    const key = `${namespace}/${endpoint.name}${endpoint.version === 1 ? '' : `_v${endpoint.version}`}`;
                    apiExamples[key] = Object.assign({ key }, endpoint);
                });
            }
        }
        catch (err) {
            error = err;
            console.log(error);
        }
        if (cb) {
            cb(error, apiExamples);
        }
        else {
            fs_1.default.writeFileSync('./src/api.json', JSON.stringify(compress_json_1.default.compress(apiExamples)));
        }
    });
}
function fetchNamespace(NAMESPACE) {
    const CSFR = 'PlVbZNc_MK8fTovNsjHXdXGa';
    return new Promise((resolve, reject) => {
        (0, request_1.default)({
            method: 'POST',
            uri: 'https://www.dropbox.com/2/api_developers/get_namespace_routes',
            json: true,
            headers: {
                cookie: `t=${CSFR}`,
                'x-csrf-token': CSFR
            },
            body: ({
                mode: "external",
                p_namespace: NAMESPACE
            })
        }, function (err, resp, body) {
            if (err)
                return reject(err);
            body.route_groups = JSON.parse(body.route_groups);
            resolve(body.route_groups.map(a => a.routeVersions).flat());
        });
    });
}
