# Installation
> `npm install --save @types/shuffle-array`

# Summary
This package contains type definitions for shuffle-array (https://github.com/pazguille/shuffle-array).

# Details
Files were exported from https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/shuffle-array.
## [index.d.ts](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/shuffle-array/index.d.ts)
````ts
declare namespace shuffleArray {
    /**
     * copy - Sets if should return a shuffled copy of the given array. By default it's a falsy value.
     * rng - Specifies a custom random number generator.
     */
    interface ShuffleOptions {
        copy?: boolean;
        rng?: () => number;
    }
    /**
     * picks - Specifies how many random elements you want to pick. By default it picks 1.
     * rng - Specifies a custom random number generator.
     */
    interface PickOptions {
        picks?: number;
        rng?: () => number;
    }
    interface ShuffleArray {
        /**
         * Randomizes the order of the elements in a given array.
         *
         * arr - The given array.
         * options - Optional configuration options.
         */
        <T>(arr: T[], options?: ShuffleOptions): T[];
        /**
         * Pick one or more random elements from the given array. If options.picks is
         * omitted or === 1, a single element will be returned; otherwise an array.
         *
         * arr - The given array.
         * options - Optional configuration options.
         */
        pick<T>(arr: readonly T[], options?: PickOptions): T | T[];
    }
}
declare var shuffleArray: shuffleArray.ShuffleArray;
export = shuffleArray;

````

### Additional Details
 * Last updated: Mon, 20 Nov 2023 23:36:24 GMT
 * Dependencies: none

# Credits
These definitions were written by [rhysd](https://github.com/rhysd).
