# Installation
> `npm install --save @types/gifencoder`

# Summary
This package contains type definitions for gifencoder (https://github.com/eugeneware/gifencoder#readme).

# Details
Files were exported from https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/gifencoder.
## [index.d.ts](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/gifencoder/index.d.ts)
````ts
/// <reference types="node" />
import { Readable, Transform } from "stream";

declare class GIFEncoder {
    constructor(width: number, height: number);

    createReadStream(): Readable;
    createWriteStream(options: GIFEncoder.GIFOptions): Transform;

    start(): void;
    setRepeat(
        /** 0 for repeat, -1 for no-repeat */
        repeat: number,
    ): void;
    setDelay(/** frame delay in ms */ delay: number): void;
    setQuality(/** image quality. 10 is default */ quality: number): void;
    setTransparent(color: number | string): void;
    addFrame(ctx: CanvasRenderingContext2D): void;
    finish(): void;

    out: GIFEncoder.ByteArray;
}

declare namespace GIFEncoder {
    interface GIFOptions {
        /** 0 for repeat, -1 for no-repeat */
        repeat: number;
        /** frame delay in ms */
        delay: number;
        /** image quality. 10 is default */
        quality: number;
    }

    interface ByteArray {
        data: number[];
        getData(): Buffer;
    }
}

export = GIFEncoder;

````

### Additional Details
 * Last updated: Tue, 07 Nov 2023 03:09:37 GMT
 * Dependencies: [@types/node](https://npmjs.com/package/@types/node)

# Credits
These definitions were written by [Carlos Precioso](https://github.com/cprecioso), and [Almeida](https://github.com/almeidx).
