# gui.py
import wx

class MainFrame(wx.Frame):
    MAX_WIDTH = 1000
    MAX_HEIGHT = 1000

    def __init__(self, *args, devices=None, drive_map=None, **kwargs):
        super().__init__(*args, **kwargs)

        panel = wx.Panel(self)
        vbox = wx.BoxSizer(wx.VERTICAL)

        # Inhalte erzeugen
        info = wx.StaticText(panel, label="Window will self-close in 5 sec")
        vbox.Add(info, 0, wx.ALL, 10) 

        auto_close_info = wx.StaticText(panel, label="Drive monitoring (read/write) every second\nThreshold 2MB")
        vbox.Add(auto_close_info, 0, wx.LEFT | wx.BOTTOM, 10)

        tray_info = wx.StaticText(panel, label="(Hover over tray icon to see MB/s)")
        vbox.Add(tray_info, 0, wx.LEFT | wx.BOTTOM, 10)

        for dev in devices or []:
            partlist = ", ".join(drive_map.get(dev, [])) or "(no partitions)"
            label = wx.StaticText(panel, label=f"{dev}: {partlist}")
            vbox.Add(label, 0, wx.LEFT | wx.BOTTOM, 10)

        panel.SetSizer(vbox)
        panel.Layout()  # Layout berechnen

        # Bevorzugte Größe des Panels ermitteln
        best_size = panel.GetBestSize()

        # Größe auf max. MAX_WIDTH x MAX_HEIGHT beschränken
        width = min(best_size.width, self.MAX_WIDTH)
        height = min(best_size.height, self.MAX_HEIGHT)

        # Client-Größe (Inhaltsgröße) setzen, nicht die Fenstergröße
        self.SetClientSize((width, height))
        self.SetPosition((200, 100))
        self.SetTitle("SmartDiskTool")

        # Optional: Fenster nach 5 Sekunden automatisch schließen
        # wx.CallLater(5000, self.Close)


if __name__ == "__main__":
    app = wx.App(False)

    devices = ['C:', 'D:']
    drive_map = {'C:': ['System', 'Recovery'], 'D:': ['Data']}

    frame = MainFrame(None, devices=devices, drive_map=drive_map)
    frame.Show()
    app.MainLoop()
