import PyInstaller.__main__
import shutil
import os

# Aufräumen vorheriger Builds
for folder in ['build', 'dist', '__pycache__']:
    if os.path.exists(folder):
        shutil.rmtree(folder)

# PyInstaller Optionen ohne --icon
opts = [
    'main.py',
    '--name=SmartDiskTool',
    '--onefile',
    '--noconsole',
    '--windowed',
    '--clean',
    '--log-level=WARN',
    '--add-data=core.py;.',  # core.py in dist/ kopieren
    '--add-data=fonts/DePixelSchmal.otf;fonts',
]

# Hidden-Imports
hidden_imports = [
    'win32com',
    'win32com.client',
    'pythoncom',
    'pystray._win32',
    'pystray._base',
    'wmi'
]

for hidden in hidden_imports:
    opts.append(f'--hidden-import={hidden}')

PyInstaller.__main__.run(opts)
