import ipdb
import glob
import os
from pathlib import Path
from argparse import ArgumentDefaultsHelpFormatter, ArgumentParser
import pyiqa

from pdb import set_trace as st

import json
import numpy as np
import torch
import torchvision.transforms as TF
from PIL import Image
import cv2
try:
    from tqdm import tqdm
except ImportError:
    # If tqdm is not available, provide a mock version of it
    def tqdm(x):
        return x


# musiq_metric = pyiqa.create_metric('musiq-ava') # for aesthetic evaluation
musiq_metric = pyiqa.create_metric('qalign') # for aesthetic evaluation


def eval_aesthetic(files): # given file list 
    all_musiq = []
    for file in tqdm(files):
        if os.path.exists(file):
            musiq_value = musiq_metric(os.path.join(file))
            all_musiq.append(musiq_value)

    musiq_value = sum(all_musiq) / len(all_musiq)
    return musiq_value

# # shape-e
# files = glob.glob('/mnt/sfs-common/yslan/Repo/3dgen/shap-e/output_dir/low-poly-model-of-a-green-pine-tree,-also-resembling-a-Christmas-tree./*.jpg')
# score = eval_aesthetic(files)
# print('shape-e: ', score)

# # point-e
# files = glob.glob('/mnt/sfs-common/yslan/Repo/3dgen/point-e/point_e/examples/exrtacted_shape_independent_imgs/low-poly-model-of-a-green-pine-tree,-also-resembling-a-Christmas-tree./*.png')
# score = eval_aesthetic(files)
# print('point-e: ', score)

# # 3dtopia
# files = glob.glob('/mnt/sfs-common/yslan/Repo/3dgen/GA-logs/t23d/baselines/3dtopia/separate_imgs/low-poly_model_of_a_green_pine_tree,_also_resembling_a_Christmas_tree._0_0/*.jpg')
# score = eval_aesthetic(files)
# print('3dtopia: ', score)

# # ln3diff
# files = glob.glob('/mnt/sfs-common/yslan/Repo/3dgen/GA-logs/t23d/baselines/ln3diff/logs/LSGM/inference/t23d/Objaverse/dit-L2/out/FID_Cals/0low-poly model of a green pine tree, also resembling a Christmas tree._3/*.jpg')
# score = eval_aesthetic(files)
# print('ln3diff: ', score)

# # ours
# files = glob.glob('/mnt/sfs-common/yslan/Repo/3dgen/GA-logs/t23d_more_results/videos/mnt/sfs-common/yslan/Repo/3dgen/GA-logs/t23d_more_results/videos/low-poly model of a green pine tree, also resembling a Christmas tree._sample-3-4-gs/*.jpg')
# files = [name for name in files if 'normal' not in name ]
# score = eval_aesthetic(files)
# print('GA: ', score)

# ours
files = glob.glob('/mnt/sfs-common/yslan/Repo/3dgen/GA-logs/t23d/baselines/gaussianCube/tree/**/*.png', recursive=True)
# files = [name for name in files if 'normal' not in name ]
score = eval_aesthetic(files)
print('GaussianCube: ', score)