# set WD and import helpers
# https://news.ycombinator.com/item?id=36575443
setwd('~/Dropbox/Directory')
backend <- "CPU"
source("./Analysis/JaxTransformer_Imports.R")
aqt <- reticulate::import("aqt")

# create a config that quantizes both forward and backward passes to int8
int8_config = aqt$jax$v2$config$fully_quantized(fwd_bits=8L, bwd_bits=8L)
Proj_jit <- eq$filter_jit( Proj <- function(x){ Linear(x) })
tmpx <- jnp$array(rnorm(nWidth_ts))
mlp_fp16 = MlpBlock(config=None)
int8_config(Proj_jit)

tmp <- aqt$jax$v2$config$DotGeneral( int8_config$dlhs, int8_config$drhs, int8_config$fwd)
tmp$make(jnp$array(1:10), jnp$array(1:10))
tmp(jnp$array(1:10), jnp$array(1:10))
MakeProj <- int8_config$make( Proj )
class(MakeProj )
( tmpx )

Proj_jit(tmpx)

jnp$round(jnp$array(rnorm(1)))
jnp$around(jnp$array(rnorm(1)))
jax$numpy$rint(jnp$array(rnorm(1)))

matmul_true_int8 <- function(lhs, rhs){
  return( result <- jnp$matmul(lhs, rhs, preferred_element_type=jnp$int32) )
}
max_int8 = 127L
quant_int8 <- function(x){ return( jnp$clip(jnp$round(x), -max_int8, max_int8)$astype(jnp$int8)) }
a <- jnp$array(matrix(rnorm((nObs <- 10000)*(initDims <- 100)), nrow = nObs))
w <- jnp$array(matrix(rnorm(initDims*50), nrow = initDims ))
aqt_matmul_int8_jit <- jax$jit( aqt_matmul_int8 <- function(a, w){
  # This function is customizable and injectable, i.e:
  # users can inject custom quant code into an AQT config.

  # Calibration. Calibration function is also customizable and injectable.
  a_s = max_int8 / jnp$max(jnp$abs(a), axis=1L, keepdims=T)
  w_s = max_int8 / jnp$max(jnp$abs(w), axis=0L, keepdims=T)

  # int8 matmul with int32 accumulator
  result <- matmul_true_int8(quant_int8(a * a_s), quant_int8(w * w_s)) / (a_s * w_s)

  return( result )
})

matmul_jit <- jax$jit( jnp$matmul )
system.time(  aqt_matmul_int8_jit(a,w) )
system.time(  matmul_jit(a,w) )

eq$nn$Linear
zzzz
