#!/usr/bin/env bash
set -ex
cd ~/Dropbox/Directory/Analysis

chmod u+r+x ./LinkOrgs_EmpiricalExamples_Master.R

ulimit -a 
parallel --number-of-cpus
parallel --number-of-cores
parallel --number-of-threads
parallel --number-of-sockets

# limit memory to 1 GB ram per job 
#ulimit -m 1000000
#ulimit -v 1000000

#ulimit -u unlimited
#export OPENBLAS_NUM_THREADS=1
#export GOTO_NUM_THREADS=1
#export OMP_NUM_THREADS=1

parallel --jobs 1 --joblog ./logfile_master.txt --load 100% --delay 2 'Rscript --vanilla ./LinkOrgs_EmpiricalExamples_Master.R {}' ::: {1..20}

#taskset --cpu-list 0-2 parallel --jobs 3 --joblog ./results/logfile_master.txt --load 100% --delay 30 --noswap ' Rscript --vanilla ./Analysis/EmpiricalAnalysisNigeria.R {} 0' ::: {1..3} 
#Rscript --vanilla  ./Analysis/EmpiricalAnalysisNigeria.R 100 1

# note:
#parallel --jobs X ''  ::: {1..6} --> X number of jobs (0 denominated) doing jobs 1 to 6
