{
  #rm(list=ls());
  setwd('~/Dropbox/Directory')
  #install.packages( "~/Documents/LinkOrgs-software/LinkOrgs", repos = NULL, type = "source",force = F)
  #library(LinkOrgs)

  # load in data and merge
  AllMatches_mat <- data.table::fread(file="./DataOutputs/NegMatches_mat.csv")
  AllMatches_mat <- rbind(AllMatches_mat,
                          data.table::fread(file="./DataOutputs/PosMatches_mat.csv"))

  # obtain base representations
  sample(AllMatches_mat$name1,10)
  sample(AllMatches_mat$name2,10)
  dim( AllMatches_mat ) / 100 * 36 / 60 / 60

  #hist( AllMatches_mat$matchProb )

  fullRun <- T; FullRunN <- 70000
  SampledIndices <- which(1:nrow(AllMatches_mat) %% ceiling(nrow(AllMatches_mat) / ifelse(fullRun,yes=FullRunN,no=100 )) == 0)
  AllMatches_mat_samp <- AllMatches_mat[SampledIndices,]
  rm( AllMatches_mat )
  length( SampledIndices )
  #install.packages("~/Documents/readme-software/readme/", repos = NULL, type = "source",force = F)
  library( readme )
  #?text::textEmbed
  text_options <- list(tokenizer_parallelism = F,
                       model = "bert-base-multilingual-uncased",
                       layers = -1L,
                       device = "cpu",
                       logging_level = "error")

  # get representations
  {
    tictoc::tic()
    transformerSummaries1 = readme::undergrad(
      documentText = AllMatches_mat_samp$name1,
      numericization_method = "transformer_based",
      textEmbed_control = text_options)

    transformerSummaries2 = readme::undergrad(
      documentText = AllMatches_mat_samp$name2,
      numericization_method = "transformer_based",
      textEmbed_control = text_options)
    tictoc_time <- tictoc::toc()
  }

  # obtain transfer learning function
  transformerSummariesDiff <- cbind(globalCosSim <- rowSums( transformerSummaries1*transformerSummaries2)/(rowSums( transformerSummaries1^2)*rowSums(transformerSummaries2^2))^0.5,
                                    abs(apply(transformerSummaries1,1,max)-apply(transformerSummaries2,1,max)),
                                    abs(apply(transformerSummaries1,1,mean)-apply(transformerSummaries2,1,median)),
                                    abs(apply(transformerSummaries1,1,min)-apply(transformerSummaries2,1,min)),
                                    abs(transformerSummaries1-transformerSummaries2),
                                    transformerSummaries1*transformerSummaries2
  )
  #library(  glmnet  )
  #transferLModel <- cv.glmnet(y = AllMatches_mat_samp$matchProb,x = as.matrix( transformerSummariesDiff ) ,alpha = 0)
  library( Compositional )
  AllMatches_mat_samp$matchProb_smooth <- (AllMatches_mat_samp$matchProb+(ep_<-0.1))/(1+2*ep_)
  summary(  AllMatches_mat_samp$matchProb_smooth )
  transferLModel <- cv.lasso.klcompreg(y = cbind(1-AllMatches_mat_samp$matchProb_smooth,
                                                 AllMatches_mat_samp$matchProb_smooth),
                                       x = as.matrix( transformerSummariesDiff ), alpha = 0, nfolds = 3)
  plot( transferLModel )
  coef_glmnet <- (coef(transferLModel,s="lambda.min"))
  coef_glmnet <- as.matrix( coef_glmnet[[2]] )
  plot( coef_glmnet )
  head( coef_glmnet )

  if(T == F){
    my_pred <- predict(transferLModel,
                       s = "lambda.min",
                       #type = "response",
                       newx=as.matrix(transformerSummariesDiff))[,2,1]
    plot(my_pred,AllMatches_mat_samp$matchProb)
    ks_test <- ks.test(my_pred[AllMatches_mat_samp$matchProb==0],
                       my_pred[AllMatches_mat_samp$matchProb>0])
    ks_test$statistic

    plot(density(my_pred[AllMatches_mat_samp$matchProb==0]),xlim = c(-3,3))
    points(density(my_pred[AllMatches_mat_samp$matchProb>0]), type = "l")
    head( AllMatches_mat_samp[order(my_pred),c("name1","name2")])
    tail( AllMatches_mat_samp[order(my_pred),c("name1","name2")],20)
  }
  if(fullRun == T){
    TransferLName <- cbind(names(text_options),
                           text_options)
    TransferLName <- apply(TransferLName,1,function(zer){
      paste(zer,collapse="_") })
    TransferLName <- paste(TransferLName,collapse="_")

    # write
    write.csv(coef_glmnet,
              file = sprintf("./DataOutputs/TransferLCoefs_%s_Full%s.csv",
                             TransferLName,
                             fullRun))
    data.table::fwrite(transformerSummaries1,
                       file = sprintf("./DataOutputs/TransferLSum1_%s_Full%s.csv",
                                      TransferLName,
                                      fullRun))
    data.table::fwrite(transformerSummaries2,
                       file = sprintf("./DataOutputs/TransferLSum2_%s_Full%s.csv",
                                      TransferLName,
                                      fullRun))

    # re-read
    coef_glmnet <- data.table::fread(sprintf("./DataOutputs/TransferLCoefs_%s_Full%s.csv",TransferLName,fullRun))[,-1]
    transformerSummaries1 <- data.table::fread(sprintf("./DataOutputs/TransferLSum1_%s_Full%s.csv",TransferLName,fullRun))
    transformerSummaries2 <- data.table::fread(sprintf("./DataOutputs/TransferLSum2_%s_Full%s.csv",TransferLName,fullRun))
  }
}
