# initialize by clearing workspace, loading important packages 
rm(list=ls())
library(fuzzyjoin);library(tidyverse)
factor2numeric <- function(x){as.numeric(as.character(x))}

setwd("~/Dropbox/Directory")
#my_directory = read.csv("./Data/markov_clustered_orgs_interpretable_201904182231.csv")
my_directory = read.csv("./Data/markov_clustered_orgs_interpretable_full_201904182237.csv")
#my_directory = read.csv("./Data/markov_clustered_orgs_interpretable_full_201904182237.csv")
#LinkedThem_directory = read.csv("./Data/markov_clustered_orgs_interpretable_full_201904182237.csv")
#save(LinkedThem_directory,file = "./LinkedThem-software/LinkedThem/data/LinkedThem_directory.Rdata")
sd_noise = 1; nIters = 34; nSamp = 50
fuzzyThres_vec = seq(0,1,length.out=10)
set.seed(12345)

###SIMULATION 1 - ALIAS IS SELECTED UNIFORMLY AT RANDOM 
fuzzy_coef <- fuzzy_coef_withSelection <- matrix(NA,nrow=nIters,ncol=length(fuzzyThres_vec))
true_coef_withSelection <- true_coef <- rep(NA,times=nIters)
for(i in 1:nIters){ 
print(i)
long.random.selection = my_directory %>%
  group_by(canonical_id) %>%
  count() %>%
  filter(n>5) %>%
  left_join(my_directory,by = "canonical_id") %>%
  group_by(canonical_id) %>%
  sample_n(2,replace=T) %>%
  mutate(alias_version = row_number()) 

df1 = long.random.selection %>%
  filter(alias_version==1) %>%
  ungroup() %>%
  select(canonical_id,alias_name)

df2 = long.random.selection %>%
  filter(alias_version==2) %>%
  ungroup() %>%
  select(canonical_id,alias_name)

#Generate covariate data 
df1$Covariate <- rnorm(nrow(df1))

#Generate outcome data 
df2$Outcome <- df1$Covariate + rnorm(nrow(df2),sd = sd_noise)

#perform regression using fuzzy-matching 
draws = sample(df1$canonical_id,nSamp)

for(thres_i in 1:length(fuzzyThres_vec) ){ 
  fuzzy_df = stringdist_join(df1[df1$canonical_id %in% draws,], df2[df2$canonical_id %in% draws,], 
                             by = "alias_name",
                             mode = "full",
                             ignore_case = TRUE, 
                             method = "jw", 
                             max_dist = fuzzyThres_vec[thres_i], 
                             distance_col = "dist") %>%  group_by(canonical_id.x) %>%   top_n(1, -dist)
  fuzzy_df <- as.data.frame(fuzzy_df[!duplicated(fuzzy_df$canonical_id.x),])
  fuzzy_coef[i,thres_i] = try(coef(summary(  lm(Outcome ~ Covariate,data = fuzzy_df) ))[2,1],T)
} 

#perform regression using ground truth 
true_df = merge(df1[df1$canonical_id %in% draws,],df2[df1$canonical_id %in% draws,],by="canonical_id")
summary(  lm(Outcome ~ Covariate,data = true_df))
true_coef[i] = coef(summary(  lm(Outcome ~ Covariate,data = true_df) ))[2,1]

#### SIMULATION 2 - ALIAS IS SELECTED NON-UNIFORMLY
directory_counts = my_directory %>%
  group_by(canonical_id) %>%
  count()

more.aliased.names = my_directory %>%
  group_by(canonical_id) %>%
  count() %>%
  filter(n>5) %>%
  left_join(my_directory,by = "canonical_id") 

more.aliased.names %>%
  filter(canonical_id==315) %>%
  mutate(slang = nchar(as.character(alias_name)),
         prank=ntile(slang,n)) %>%
  arrange(prank) %>%
  summarise(cut(7,9,labels=alias_name))

long.selection.biased = my_directory %>%
  group_by(canonical_id) %>%
  count() %>%
  filter(n>5) %>%
  left_join(my_directory,by = "canonical_id") %>%
  group_by(canonical_id) %>%
  sample_n(1)

long.selection.biased$Covariate =  rnorm(nrow(long.selection.biased))
long.selection.biased$Covariate

more.aliased.names %>%
  left_join(long.selection.biased %>% select(canonical_id,Covariate)) %>%
  rename(number.of.aliases=n) %>%
  mutate(slang=nchar(as.character(alias_name)),
         prank=ntile(slang,number.of.aliases)) %>%
  arrange(canonical_name,prank) %>%
  group_by(canonical_id) %>%
  filter(canonical_id==315) 

selection = more.aliased.names %>%
  left_join(long.selection.biased %>% select(canonical_id,Covariate)) %>%
  rename(number.of.aliases=n) %>%
  mutate(slang=nchar(as.character(alias_name)),
         prank=ntile(slang,number.of.aliases)) %>%
  arrange(canonical_name,prank) %>%
  group_by(canonical_id) %>%
  summarise(
    number.of.aliases=unique(number.of.aliases),
    p=pnorm(unique(Covariate)),
    pick=factor2numeric(cut(p,
             breaks=seq(0,number.of.aliases)/number.of.aliases,
             labels=seq(1,number.of.aliases))))
  
second.selection = selection %>% 
  left_join(
    more.aliased.names %>%
    left_join(long.selection.biased %>% select(canonical_id,Covariate)) %>%
    rename(number.of.aliases=n) %>%
    mutate(slang=nchar(as.character(alias_name)),
         prank=ntile(slang,number.of.aliases)),
   by=c("canonical_id","number.of.aliases","pick"='prank'))

second.selection$Outcome = second.selection$Covariate + rnorm(nrow(second.selection),sd = 0.5)

df2 = second.selection %>%
  select(alias_name,canonical_id,Outcome)

df1 = long.selection.biased %>%
  select(canonical_id,alias_name,Covariate)

#get draws 
draws = sample(df1$canonical_id,nSamp)

########################
#perform analysis 
########################

#perform regression using fuzzy-matching 
for(thres_i in 1:length(fuzzyThres_vec) ){ 
  fuzzy_df_withSelection = stringdist_join(df1[df1$canonical_id %in% draws,], df2[df2$canonical_id %in% draws,], 
                             by = "alias_name",
                             mode = "full",
                             ignore_case = TRUE, 
                             method = "jw", 
                             max_dist = fuzzyThres_vec[thres_i], 
                             distance_col = "dist") %>%  group_by(canonical_id.x) %>%   top_n(1, -dist)
  fuzzy_df_withSelection <- as.data.frame( fuzzy_df_withSelection )
  fuzzy_coef_withSelection[i,thres_i] = coef(summary(  lm(Outcome ~ Covariate,data = fuzzy_df_withSelection) ))[2,1]
} 

#perform regression using ground truth 
true_df_withSelection = merge(df1[df1$canonical_id %in% draws,],df2[df1$canonical_id %in% draws,],by="canonical_id")
true_coef_withSelection[i] = coef(summary(  lm(Outcome ~ Covariate,data = true_df_withSelection) ))[2,1]
} 

#Calculate RMSE for each algorithm in each design 
errorsMat_fuzzy =  (fuzzy_coef - 1)^2 
rmse_fuzzy <- sqrt(  colMeans( errorsMat_fuzzy ) )
rmse_fuzzy_se <- sqrt(apply(errorsMat_fuzzy,2,sd)/nrow(errorsMat_fuzzy)) #approximate SEs
rmse_true <- sqrt(mean( (true_coef - 1)^2,na.rm=T))

errorsMat_fuzzy_withSelection = (fuzzy_coef_withSelection - 1)^2
rmse_fuzzy_withSelection <-sqrt(  colMeans( errorsMat_fuzzy_withSelection) ) 
rmse_fuzzy_withSelection_se <- sqrt(apply(errorsMat_fuzzy_withSelection,2,sd)/nrow(errorsMat_fuzzy_withSelection)) #approximate SEs
rmse_true_withSelection <- sqrt(mean( (true_coef_withSelection - 1)^2,na.rm=T))

#present results 
ylims_ = c(0,max(rmse_fuzzy+1.96*rmse_fuzzy_se,rmse_fuzzy_withSelection+1.96*rmse_fuzzy_withSelection_se))

#save(file="SyntheticExperimentResults.RData")

#no bias 
pdf("./Figures/SimFig_NoBias.pdf")
{
par(mar=c(5, 5, 4, 2) )
plot(0,type="b",ylim =ylims_,xlim=c(min(fuzzyThres_vec),max(fuzzyThres_vec)),
     cex=0,ylab = "RMSE",xlab = "Fuzzy Matching Threshold",
     main = "Random Alias Design",
     cex.main=2,cex.lab=2)
for(i in 1:length(fuzzyThres_vec)){
  points(c(fuzzyThres_vec[i],fuzzyThres_vec[i]),
           c(rmse_fuzzy[i]-1.96*rmse_fuzzy_se[i],rmse_fuzzy[i]+1.96*rmse_fuzzy_se[i]),type="l", lwd=3,col="lightgray")
}
points(fuzzyThres_vec,rmse_fuzzy,cex=2,pch = 19)
abline(h=rmse_true,lty = 2,col="darkgray",lwd=2)
text(x=0.70, y=rmse_true,label = "RMSE with All \n Correct Matches",cex=2 )
}
dev.off()

#with bias 
pdf("./Figures/SimFig_WithBias.pdf")
{
par(mar=c(5, 5, 4, 2) )
plot(0,type="b",ylim =ylims_,xlim=c(min(fuzzyThres_vec),max(fuzzyThres_vec)),
     cex=0,ylab = "RMSE",xlab = "Fuzzy Matching Threshold",
     main = "Biased Alias Design",
     cex.main=2,cex.lab=2)
for(i in 1:length(fuzzyThres_vec)){
  points(c(fuzzyThres_vec[i],fuzzyThres_vec[i]),
         c(rmse_fuzzy_withSelection[i]-1.96*rmse_fuzzy_withSelection_se[i],rmse_fuzzy_withSelection[i]+1.96*rmse_fuzzy_withSelection_se[i]),type="l", lwd=3,col="lightgray")
}
points(fuzzyThres_vec,rmse_fuzzy_withSelection,cex=2,pch=19)
abline(h=rmse_true_withSelection,lty = 2,col="darkgray",lwd=2)
text(x=0.70, y=rmse_true_withSelection,label = "RMSE with All \n Correct Matches",cex=2 )
}
dev.off()
