devtools::install_github('cjerzak/LinkOrgs-software/LinkOrgs', force = F )
library(LinkOrgs)
{
  x_orgnames <- c("apple","oracle","enron inc.","mcdonalds corporation")
  y_orgnames <- c("apple corp","oracle inc","enron","mcdonalds")
  x <- data.frame("orgnames_x"=x_orgnames)
  y <- data.frame("orgnames_y"=y_orgnames)
  z <- data.frame("orgnames_x"=x_orgnames[1:2], "orgnames_y"=y_orgnames[1:2])
  z_true <- data.frame("orgnames_x"=x_orgnames, "orgnames_y"=y_orgnames)

  linkedOrgs <- LinkOrgs(x  = x,
                         y =  y,
                         by.x = "orgnames_x",
                         by.y = "orgnames_y",
                         algorithm = "bipartite",
                         MaxDist = 0.4,
                         DistanceMeasure = "jaccard")
  AssessMatchPerformance(x  = x,
                         y =  y,
                         by.x = "orgnames_x",
                         by.y = "orgnames_y",
                         z = z,
                         z_true = z_true)
  fuzzzyOrgs <- FastFuzzyMatch(x = x,
                               y =  y,
                               MaxDist = 0.4,
                               DistanceMeasure = "jaccard",
                               by.x = "orgnames_x",
                               by.y = "orgnames_y")

}
