#!/usr/bin/env Rscript
f2n <- function(x){as.numeric(as.character(x))}
DisappList <- function(.){ret_<-.;if(is.list(.)){if(length(unlist(.))==0){ret_ <- NULL}};return(ret_)}
ai <- as.integer

print2 <- function(text, quiet = F){
  if(!quiet){ print( sprintf("[%s] %s" ,format(Sys.time(), "%Y-%m-%d %H:%M:%S"),text) ) }
}

GetPrSameOGivenAiAj <- function(a_i,a_j=NULL,justIndicateIfNonzero=F,justReturnLinks=F){
  if(justReturnLinks == T){
    # reduce search pool once
    red_indices <- which(all_raw_names %fin% a_i)
    all_raw_names_ <- all_raw_names[red_indices]
    all_raw_to_ <- all_raw_to[red_indices]

    # then search within reduced pool
    to_list <- sapply(a_i, function(a_i_){ list(all_raw_to_[all_raw_names_ %fin% a_i_]) })

    return(  to_list  )
  }
  Mi <- my_data[all_raw_names %fin% a_i,]
  if(justIndicateIfNonzero == F){
    PrUGivenAi_list <- {
      to_names <- Mi$to
      to_ <- c(prop.table( Mi$weights ))
      names(to_) <- to_names
      list(  as.data.frame(t(to_)) )
    }
  }
  if(is.null(a_j)){ return(PrUGivenAi_list) }
  if(!is.null(a_j)){
    Mj <- my_data[all_raw_names == a_j,]
    if(justIndicateIfNonzero == F){
      PrUGivenAj_list <- {
        to_names <- Mj$to
        to_ <- c(prop.table( Mj$weights ))
        names(to_) <- to_names
        list(  as.data.frame(t(to_)) )
      }
      list_AiAj <- c(PrUGivenAi_list,PrUGivenAj_list)
      PrUGivenAiAj_list <- do.call(plyr::rbind.fill,list_AiAj)
      PrUGivenAiAj_list[is.na(PrUGivenAiAj_list)] <- 0

      MatchProb_AiAj <- sum(PrUGivenAiAj_list[1,] * PrUGivenAiAj_list[2,])
      return(  MatchProb_AiAj  )
    }
    if(justIndicateIfNonzero == T){
      return( NonZeroIndicator <- length(intersect(Mi$to, Mj$to)) )
    }
  }
}

name2char_indices <- function(names_,returnWordPositions = F){
  # convert characters to indices of associated character vectors
  do.call(rbind,sapply(names_,function(name_){
    indexes <- ai(charIndicators[,2][ fmatch(strsplit(name_,split="")[[1]],
                                             charIndicators[,1])]) - 1L
    indexes <- c(START_CODON_WORD_zi,
                 indexes,
                 STOP_CODON_WORD_zi
                 # ,CLS_CODON_WORD_zi
                 )
    presentChars_ <- 1:min(c(length(indexes), max_nCharsPerWord))
    BASE_name2char_HOLDER[presentChars_] <- indexes[presentChars_]
    return( BASE_name2char_HOLDER )
  },simplify = F ) )
}

FormatNParams <- function(num) {
  if (num < 1000) {
    return(as.character(num))
  } else if (num < 1000000) {
    return(paste(round(num / 1000, 1), "K", sep = ""))
  } else if (num < 1000000000) {
    return(paste(round(num / 1000000, 1), "M", sep = ""))
  } else {
    return(paste(round(num / 1000000000, 1), "B", sep = ""))
  }
}

GetList <- function(name_raw, name_pushed = NULL,
                    MaxUqWords = NULL,
                    MaxUqAliases = NULL){
  name_raw <- enc2utf8(name_raw)
  CINDICES <- name2char_indices( unique_words <- unique(unlist(strsplit(name_raw,split=" ")) ) )
  if(!is.null(MaxUqWords)){
    if(nrow(CINDICES) > MaxUqWords){
      CINDICES <- CINDICES[1:MaxUqWords,]
      unique_words <- unique_words[1:MaxUqWords]
  }}
  unique_words_key <- 1:length( unique_words )
  names(unique_words_key) <- unique_words

  name_raw_split <- strsplit(name_raw, split = " ")
  WINDICES <- sapply(1:length(name_raw_split),function(zer){
    return_contrib <- unique_words_key[ name_raw_split[[zer]] ]
    return(  return_contrib  )
  })
  WINDICES <- do.call(rbind,lapply(WINDICES,function(zer){
    c(zer-1L,rep(-1L,max(0,max_nWordsPerAlias-length(zer))))[1:max_nWordsPerAlias]
  }))

  if(!is.null(MaxUqWords)){
    # length(name_raw) # is controlled length
    # dim( WINDICES ) # is fixed length based on length(name_raw)
    # dim( CINDICES ) # is variable length based on number of unique words in total name_raw
    # those code rectifies these dimensions
    if(nrow(CINDICES) < MaxUqWords){
      CINDICES <- try(rbind(CINDICES,
                        matrix(-1L, nrow = MaxUqWords - nrow(CINDICES),
                                    ncol = max_nCharsPerWord)), T)
    }
  }

  if(!is.null(MaxUqAliases)){
    if(nrow(WINDICES) < MaxUqAliases){
      WINDICES <- try(rbind(WINDICES,
                            matrix(-1L,
                                   nrow = MaxUqAliases - nrow(WINDICES),
                                   ncol = max_nWordsPerAlias)), T)
      if("try-error" %in% class(WINDICES)){ browser() }
    }
  }

  return( list("CINDICES" = jnp$array( CINDICES, jnp$int32),
               "WINDICES" = jnp$array( WINDICES, jnp$int32) ) ) }
