if(exampleNum == 4){
  for(type_ in c("all","fuzzyOnly")){
    colnames(Rsub_final) <- gsub(colnames(Rsub_final), pattern = "\\.log\\(MeanAssets \\+ 1\\)", replace ="")
    pdf(sprintf('./Figures/Example%s_subplot1_%s.pdf',exampleNum,type_), height = 7, width = 11 )
    {
      zones <- matrix(0,nrow = 3, ncol=3,byrow = TRUE)
      zones[1,] <- 1; zones[2,] <- 2:4; zones[3,] <- 5
      innerHeights <- innerWidths <- 7
      layout(zones, widths=c(innerWidths,innerWidths/7,innerWidths),
             heights = c(innerHeights*0.3,innerHeights,innerHeights/2))

      xlims_ <- sapply(c("ml","markov","fuzzy","bipartite"), function(zer){
        tmp_ <- Rsub_final[,c(sprintf('n_%s',zer), sprintf('n_%s',zer))]
        summary(tmp_[!is.na(tmp_[,2])])[c(1,6)] })
      xlims_ <- c(min(xlims_[1])*0.75, 2000)

      # plot 1
      {
        par(mar=rep(0.01,times=4))
        plot(0,col="white", bty="n",xaxt = 'n',yaxt ='n',xlab="",ylab="")
        ml_col <- "purple"; bi_col <- "darkgray"; markov_col <- "black"; fuzzy_col <- "red"
        ml_lty <- 4; bi_lty <- 3; markov_lty <- 1; fuzzy_lty <- 2
        if(type_ == "all"){
          legend("center",
                 legend=c('Fuzzy Matching','LinkOrgs, Markov','LinkOrgs, Bipartite','LinkOrgs, Transformer'),bty = 'n',
                 pch=c('F','M',"B","T"),
                 lwd=2.5,
                 lty = c(fuzzy_lty,markov_lty,bi_lty,ml_lty),
                 col=c(fuzzy_col,markov_col,bi_col,ml_col),cex=2)
        }
      }

      quant_ <- seq(min(dist_seq_full)+0.01,max(dist_seq_full)-0.01,length.out=3)
      seq_ = sapply(quant_,function(zer){ which.min(abs(dist_seq_full - zer))})
      pch_cex <- 2; lwd_value <- 1.3
      # plot 2
      {
        par(mar=c(0,12,0,0))
        plot(Rsub_final[,"n_fuzzy"], abs(Rsub_final[,"fuzzy_coef_obs"] - COEF_TRUE),
             lty = 4,col = fuzzy_col,pch = fuzzy_lty, lwd = lwd_value,
             #xaxt ="n",
             cex.axis = 2.5, cex.lab = 2,
             mgp=c(5,1,.5),
             ylim = c(.5,2.25),
             xlim = c(xlims_[1], 5000),
             ylab = "Absolute Deviation From Truth",
             type  = "l",log="x")
        abline(v = nrow(z_red_human),lty = 2, col = "grey")
        text(x = nrow(z_red_human),  y = 2, labels = "True \n Size",col="grey",cex = 2)
        tmp__ <- paste(sprintf("10^%s",3:10),collapse=",")
        #axis(1,at = 10^(3:10), labels = eval(parse(text=sprintf("expression(%s)", tmp__))), cex.axis = 2)
        points(Rsub_final[,"n_fuzzy"][seq_], abs(Rsub_final[,"fuzzy_coef_obs"][seq_] - COEF_TRUE),
               type="p",pch="F",col=fuzzy_col,cex=pch_cex)
        abline(h=0,col="gray",lty=2)

        if(type_ == "all"){
          y_bi_ex4 <- abs(Rsub_final[,"bipartite_coef_obs"] - COEF_TRUE)
          points(Rsub_final[,"n_bipartite"],y_bi_ex4 ,type="l",col=bi_col,lty = bi_lty,lwd = lwd_value)
          points(Rsub_final[,"n_bipartite"][seq_],y_bi_ex4[seq_],type="p",pch="B",col=bi_col,cex=pch_cex)

          y_mark_ex4  <- abs(Rsub_final[,"markov_coef_obs"] - COEF_TRUE)
          points(Rsub_final[,"n_markov"], y_mark_ex4,type="l", col=markov_col,lty = markov_lty,lwd = lwd_value)
          points(Rsub_final[,"n_markov"][seq_], y_mark_ex4[seq_],type="p",pch="M",col=markov_col,cex=pch_cex)

          y_ml_ex4  <- abs(Rsub_final[,"ml_coef_obs"] - COEF_TRUE)
          points(Rsub_final[,"n_ml"], y_ml_ex4,type="l", col=ml_col,lty = ml_lty,lwd = lwd_value)
          points(Rsub_final[,"n_ml"][seq_], y_ml_ex4[seq_],type="p",pch="T",col=ml_col,cex=pch_cex)
        }
      }

      # plot 3
      {
        par(mar=rep(0.01,times=4))
        plot(0,col="white", bty="n",xaxt = 'n',yaxt ='n',xlab="",ylab="")
      }

      # plot 4
      {
        par(mar=c(0,10,0,0))
        plot(Rsub_final[,"n_fuzzy"], Rsub_final[,"fuzzy_propTruthInCI"],
             lty = 4,col = fuzzy_col, pch = fuzzy_lty, lwd = lwd_value,
             #xaxt ="n",
             cex.axis = 2.5, cex.lab = 2,
             mgp=c(5,1,.5), xlim = xlims_, ylim = c(0,0.5),
             ylab = "Proportion of Simulation CIs \n Overlapping with Ground Truth CI",
             type  = "l",log="x")
        tmp__ <- paste(sprintf("10^%s",3:10),collapse=",")
        #axis(1,at = 10^(3:10), labels = eval(parse(text=sprintf("expression(%s)", tmp__))), cex.axis = 2)
        points(Rsub_final[,"n_fuzzy"][which.max(Rsub_final[,"fuzzy_propTruthInCI"])[1]], max(Rsub_final[,"fuzzy_propTruthInCI"]),type="p",pch="F",col=fuzzy_col,cex=pch_cex)
        abline(h=0,col="gray",lty=2)
        text(x = nrow(z_red_human),  y = 0.47, labels = "True \n Size",col="grey",cex = 2)
        abline(v = nrow(z_red_human),lty = 2, col = "grey")

        if(type_ == "all"){
          points(Rsub_final[,"n_bipartite"], Rsub_final[,"bipartite_propTruthInCI"],type="l",col=bi_col,lty = bi_lty,lwd = lwd_value)
          points(Rsub_final[,"n_bipartite"][which.max(Rsub_final[,"bipartite_propTruthInCI"])], max(Rsub_final[,"bipartite_propTruthInCI"]),type="p",pch="B",col=bi_col,cex=pch_cex)

          points(Rsub_final[,"n_markov"], Rsub_final[,"markov_propTruthInCI"],type="l", col=markov_col,lty = markov_lty,lwd = lwd_value)
          points(Rsub_final[,"n_markov"][which.max(Rsub_final[,"markov_propTruthInCI"])], max(Rsub_final[,"markov_propTruthInCI"]),type="p",pch="M",col=markov_col,cex=pch_cex)

          points(Rsub_final[,"n_ml"], Rsub_final[,"ml_propTruthInCI"],type="l", col=ml_col,lty = ml_lty,lwd = lwd_value)
          points(Rsub_final[,"n_ml"][which.max(Rsub_final[,"ml_propTruthInCI"])], max(Rsub_final[,"ml_propTruthInCI"]),type="p",pch="T",col=ml_col,cex=pch_cex)
        }
      }

      # plot 5
      {
        par(mar=rep(0.01,times=4))
        plot(0,col="white", bty="n",xaxt = 'n',yaxt ='n',xlab="",ylab="")
        text(0,labels = "Size of Matched Dataset \n (Large Values Mean Higher Acceptance Threshold)",
             cex = 3)
      }
    }
    dev.off()
  }
}
if(exampleNum == 5){
  #RX_final[RX_final$maxDist==1,]$LinkOrgs_mlFalseNegatives <- RX_final[RX_final$maxDist==1,]$FuzzyFalseNegatives  <-   0
  #RX_final[RX_final$maxDist==1,]$LinkOrgs_mlFalsePositives <- RX_final[RX_final$maxDist==1,]$FuzzyFalsePositives <- nrow(x_red)*nrow(y_red)-76
  #RX_final[RX_final$maxDist==1,]$LinkOrgs_mlTrueNegatives <- RX_final[RX_final$maxDist==1,]$FuzzyTrueNegatives <- 0
  #RX_final[RX_final$maxDist==1,]$LinkOrgs_mlTruePositives <- RX_final[RX_final$maxDist==1,]$FuzzyTruePositives <- 76

  link_tmp <- link_markov[link_markov$minDist <= 0.9,]
  AssessMatchPerformance(x=x_red, y = y_red,
                         by.x = results_by_x,by.y=results_by_y,
                         z = link_tmp, z_true = z_red_human)
  forStars <- z_red_human[,c("Name1","Name2","Language2")]
  z_red_human$Name1[!z_red_human$Name1 %in% link_tmp$Name1]
  z_red_human$Name1[z_red_human$Name1 %in% link_tmp$Name1]
  colnames(forStars) <- c("Latin Name","Non-Latin Name", "Non-Latin Language")
  tmp_ <- forStars[forStars$`Non-Latin Language` == "arabic",]
  #head(tmp_[sample(1:nrow(tmp_),5),1:2])
  forStars <- forStars[forStars$`Latin Name` %in% c("google", # chinese
                                                    "citibank", # japanese
                                                    "pricewaterhousecoopers (pwc)" #arabic
  ),]
  forStars[,3] <- paste(toupper(substr(forStars[,3], 1, 1)), substr(forStars[,3], 2, nchar(forStars[,3])), sep="")
  stargazer::stargazer(as.matrix( forStars),rownames = F,
                       label = "tab:crosslang",
                       title = 'A sample of the the organizational entities in the cross-language dataset. We attempt to match the pool of Latin-based names to their associated name in Arabic, Japanese, or Mandarin Chinese.')
}
