{
  for(OUTER_ in OUTER_ITERATION_SEQUENCE){

    # get entry + name entries
    entry_ <- my_grid[OUTER_,]
    for(entry_name_ in names(entry_)){ eval(parse(text = sprintf("%s = entry_$%s",entry_name_,entry_name_))) }
    algorithm_i <- as.character( algorithm_i )
    distanceMeasure_i <- as.character( distanceMeasure_i )

    # process initial data
    {
      # RX_final <- RY_final <- c(); save_ = F

      # process example data
      source("./Analysis/LinkOrgs_ProcessExampleData.R")

      # to lower
      eval(parse(text = sprintf("y_red$%s = tolower(y_red[[by.y]])",by.y)))
      eval(parse(text = sprintf("x_red$%s = tolower(x_red[[by.x]])",by.x)))
      eval(parse(text = sprintf("z_red_human$%s = tolower(z_red_human[[by.x]])",by.x)))
      eval(parse(text = sprintf("z_red_human$%s = tolower(z_red_human[[by.y]])",by.y)))

      if(!reduceData){
        if( length(setdiff(unlist(z_red_human[by.x]), unlist(x_red[by.x]) )) > 0 |  length(setdiff(unlist(z_red_human[by.y]), unlist(y_red[by.y]) )) > 0){ stop("PROBLEMS IN Z_HUMAN") } }
    }

    # Main analysis sequence
    {
      LinkOrgs::print2( c(exampleNum_i, algorithm_i) )
      LinkOrgs::print2( tail(log(sort( sapply(ls(),function(x){object.size(get(x))})) )) )

      # set acceptance parameters
      maxDist <- maxDist_network <- NULL
      AveMatchNumberPerAlias <- 4.
      AveMatchNumberPerAlias_network <- 0.5
      if(distanceMeasure_i == "ml"){ AveMatchNumberPerAlias_network <- AveMatchNumberPerAlias_network/2 }

      LinkOrgs::print2(as.character(c(exampleNum_i, as.character(algorithm_i), as.character(distanceMeasure_i))))
      if(!algorithm_i %in% "fuzzy"){
        # x_red[[by.x]]
        # y_red[[by.y]]
        sysTime_LinkOrgs <- system.time( z_red_LinkOrgs <- try(LinkOrgs(
          x = x_red, by.x = by.x,
          y = y_red, by.y = by.y,
          ReturnProgress = T,
          openBrowser = F,
          ReturnDecomposition = F,
          ReturnDiagnostics = T,
          ToLower = T,
          NormalizeSpaces = T,
          RemovePunctuation = F,
          MaxDist = maxDist,
          algorithm = algorithm_i,
          MaxDist_network = maxDist_network,
          DistanceMeasure = distanceMeasure_i,
          AveMatchNumberPerAlias = AveMatchNumberPerAlias,
          AveMatchNumberPerAlias_network = AveMatchNumberPerAlias_network,
          qgram = qgramMaster),T) )
        if("try-error" %in% class(z_red_LinkOrgs)){ browser() }
        z_red_LinkOrgs$ExecutionTime <- sysTime_LinkOrgs[1]

        # write LinkOrgs
        data.table::fwrite(z_red_LinkOrgs,
                           file = sprintf("./Results/z_LinkOrgs_Ex%s_%s_%s.csv",exampleNum_i,algorithm_i,distanceMeasure_i))
        rm(directory_LinkIt, directory_trigrams, z_red_LinkOrgs)
      }

      # Perform merge via fuzzy match
      if(algorithm_i %in% "fuzzy"){
        sysTime_fuzzy <- system.time(z_red_fuzzy <- LinkOrgs::pFuzzyMatch_discrete(
          x = x_red, by.x = by.x,
          y = y_red, by.y = by.y,
          DistanceMeasure = FuzzyDistanceMeasureMaster,
          AveMatchNumberPerAlias = 2*AveMatchNumberPerAlias,
          qgram = qgramMaster, openBrowser=F)  )
        z_red_fuzzy$minDist <- z_red_fuzzy$stringdist
        if(nrow(z_red_fuzzy) > 0){ z_red_fuzzy$ExecutionTime <- sysTime_fuzzy[1] }
        data.table::fwrite(z_red_fuzzy,
                           file = sprintf("./Results/z_LinkOrgs_Ex%s_%s_%s.csv",exampleNum_i,"fuzzy",FuzzyDistanceMeasureMaster))
      }
    }
  }# end OUTER_ in OUTER_ITERATION_SEQUENCE
}




tmp <- data.table::fread( sprintf("./Results/z_LinkOrgs_Ex%s_%s_%s.csv",
                                   exampleNum_i,algorithm_i,distanceMeasure_i) )
tmp[[by.x]]
tmp[[by.y]]

