#!/usr/bin/env Rscript
{
  # install.packages("~/Documents/LinkOrgs-software/LinkOrgs",repos = NULL, type = "source", force = F)
  rm(list=ls())

  set.seed(1);
  JustEvaluateResults <- F
  reduceData = F
  if(useRCE <- (Sys.info()["sysname"] != "Darwin")){
    options(repos=structure(c(CRAN="http://cran.r-project.org")), INSTALL_opts = c('--no-lock'))
    lib_loc = "~/.conda/envs/Rtensorflow2/lib/R/library";
    .libPaths(unique( c(.libPaths(),"./apps/R_version", lib_loc)) )
    #install.packages("foreach",INSTALL_opts = c("--no-lock"),lib = "./apps/R_version")
    #try(devtools::install_github('cjerzak/LinkOrgs-software/LinkOrgs',force=F,lib="./apps/R_version"), T);
    library(LinkOrgs,lib.loc = "./apps/R_version")
  }
  if(useRCE == F){ setwd('~/Dropbox/Directory') }

  library(LinkOrgs); library(fastmatch)
  FirstLetterUpper <- function(x) {substr(x, 1, 1) <- toupper(substr(x, 1, 1)); return( x ) }
  f2n <- function(ze){as.numeric(as.character(ze))}

  # example directory:
  #exampleNum = 2 # -> libgober analysis (687 by 6886)
  #exampleNum = 3 # -> crosson replication (incomplete)
  #exampleNum = 4 # -> market cap analysis (8592 by 1000)
  #exampleNum = 5 # -> non-latin linkage example (766 by 766)
  #exampleNum = 6 # -> person name match
  #exampleNum = 7 # -> ycombinator name matches

  # set grid parameters
  qgramMaster = 2;
  my_grid <- expand.grid(
    #"exampleNum_i" = c(7),
    "exampleNum_i" = c(5,2,4, 7),
    "algorithm_i" = c("bipartite","markov","ml","fuzzy"),
    "distanceMeasure_i" =  c(FuzzyDistanceMeasureMaster <- 'jaccard', "ml")
  )
  my_grid <- rbind(my_grid, expand.grid(
                     "exampleNum_i" =  c(5,2,4),
                     "algorithm_i" =  c( "transfer"),
                     "distanceMeasure_i" =  c( "transfer") ))

  # general restrictions
  my_grid <- my_grid[!(my_grid$algorithm_i == "ml" &  my_grid$distanceMeasure_i != "ml"),]
  my_grid <- my_grid[!(my_grid$exampleNum_i == 6 & !(my_grid$algorithm_i %in% c("ml","fuzzy","transfer"))),]
  my_grid <- my_grid[!(my_grid$algorithm_i == "fuzzy" &  my_grid$distanceMeasure_i != FuzzyDistanceMeasureMaster),]

  # for right now, drop ml + bipartite
  my_grid <- my_grid[!(my_grid$algorithm_i == "bipartite" & my_grid$distanceMeasure_i == "ml"),]

  # other subsets
  # my_grid <- my_grid[my_grid$algorithm == "ml", ]
  my_grid <- my_grid[my_grid$exampleNum_i == 7,]

  # reset rownames
  row.names(my_grid) <- 1:nrow(my_grid)

  # setup iterator
  COMMAND_ARG_INPUT <- try(as.integer((args <- commandArgs(TRUE))[1]),T)
  if(!is.na(COMMAND_ARG_INPUT)){ OUTER_ITERATION_SEQUENCE <- COMMAND_ARG_INPUT }
  if(is.na(COMMAND_ARG_INPUT)){
    my_grid <- my_grid[ my_grid$algorithm_i!="transfer", ]
    OUTER_ITERATION_SEQUENCE <- 1:nrow(my_grid)
  }

  # uncomment if needing to subset
  OUTER_ITERATION_SEQUENCE <- OUTER_ITERATION_SEQUENCE[c(1,3,5)]; LinkOrgs::print2("Subsetting outer seq...")
  # my_grid[OUTER_ITERATION_SEQUENCE,]

  if(!JustEvaluateResults){
    source("./Analysis/LinkOrgs_EmpiricalExamples_Run.R" )
  }

  if(JustEvaluateResults){
    source("./Analysis/LinkOrgs_EmpiricalExamples_Evaluate.R" )
  }

  # analyze one result
  if(T == F){
    z_red_LinkOrgs[[1]][grep(z_red_LinkOrgs[[1]]$Name,pattern = (ID_ <- 'HSBC')),]
    z_red_fuzzy_list[[1]][grep(z_red_LinkOrgs[[1]]$Name,pattern=ID_),]
    string_val = stringdist::stringdist(tolower('HSBC Holdings plc'),tolower('HSBC'),
                                        method=FuzzyDistanceMeasureMaster,q=2)
    string_dists_ = stringdist::stringdist(tolower('HSBC Holdings plc'),tolower(z_red_human[[2]]),
                                           method=FuzzyDistanceMeasureMaster,q=2)
    which_min_ = which.min(abs(string_dists_-string_val)^2)
    (z_red_human[which_min_,])
    tolower(z_red_human[which_min_,2])
    stringdist::stringdist(tolower('HSBC Holdings plc'),tolower('HSBC Holdings'),
                           method=FuzzyDistanceMeasureMaster,q=2)
  }
}
