# bipartite clustering
{
  print2("Performing greedy clustering..")

  library(igraph)
  WEIGHTS_VEC  <- my_data$weights
  FROM_VEC     <- my_data$from
  names(WEIGHTS_VEC) <- FROM_VEC
  my_g <- graph_from_data_frame(my_data,directed = F)
  V(my_g)$type <- V(my_g)$name %fin% my_data[,1] #the FIRST column of edges is TRUE type
  E(my_g)$weight <- as.numeric(WEIGHTS_VEC)
  print2(  is_bipartite(my_g)  )

  incidence_g = igraph::as_adjacency_matrix(my_g,attr="weight")
  incidence_g = incidence_g[grepl(row.names(incidence_g),pattern = "ALIAS___"),
                            grepl(colnames(incidence_g),pattern = "LINK___")]

  my_communities = cluster_fast_greedy(my_g,
                                       merges = F, modularity = F)
  my_communities <- membership(my_communities)
  my_communities <- my_communities[1:length(WEIGHTS_VEC)]
  my_communities <- my_communities[FROM_VEC]
  mean( names(my_communities) ==  FROM_VEC)
  head(sort(table(my_communities),decreasing=T))
  canonical_names = sapply(1:length(my_communities), function(ze){
    sort(WEIGHTS_VEC[which(my_communities == my_communities[ze])],decreasing=T)[1]  } )
  canonical_names = gsub(names( canonical_names ),pattern = "ALIAS___",replace="")
  directory = cbind("alias_id" =  1:length(my_communities),
                    "canonical_id" = my_communities,
                    "alias_name"  = gsub(names(my_communities),pattern="ALIAS___",replace=""),
                    "canonical_name" = canonical_names)
  row.names(directory) <- NULL; save(directory,file = "./DataOutputs/LinkIt_directory_bipartite.Rdata")

  # save  files
  {
    print2("Saving greedy clustering output...")

    #GET TRIGRAMS
    method_ = "bipartite";thresh_ = "40"
    load(file = sprintf("./DataOutputs/directory_data_%s_thresh%s/LinkIt_directory_%s.Rdata",method_,thresh_,method_))
    #load(file = "./DataOutputs/directory_data/LinkIt_directory_markov_trigrams.Rdata")

    if(method_ == "markov"){directory_trigrams = trigram_index(as.character(directory$alias_name))}
    if(method_ == "bipartite"){directory_trigrams = trigram_index(directory[,"alias_name"])}
    save(directory_trigrams,file = sprintf("./DataOutputs/directory_data_%s_thresh%s/LinkIt_directory_%s_trigrams.Rdata",method_,thresh_,method_))
    #load(sprintf("./DataOutputs/directory_data_%s/LinkIt_directory_%s_trigrams.Rdata",method_,method_))
    dim( directory_trigrams )
    #4753444,4834836
  }
}

# sbm
if("bipartiteSBM" %in% whichDo){
  library(sbm)
  myBipartiteSBM <- estimateBipartiteSBM(netMat = as.matrix( incidence_g )[1:5000,1:1000],
                                         model = "poisson",
                                         estimOptions = list(plot = FALSE))
}
