
{ 
  n_A = 1000 
  n_B = 1000 
  match_frac = seq(0,1,length.out = 100)
  C_CheckMatches = apply(cbind(n_A*match_frac,n_B*match_frac), 1, max)
  C_CheckNonMatches = (n_A*(1-match_frac)*n_B*(1-match_frac))
  ylims = summary(c(C_CheckMatches,C_CheckNonMatches))[c(1,6)]
  pdf("./Draft/CheckingComplexity.pdf", width = 7, height = 6)
  par(mar=c(5, 7, 4, 2) )
  plot(match_frac,C_CheckNonMatches,type = "l",log="y",
       xlab = "Fraction of Observations Matched",
       ylab = "Computations Needed to Check Results \n(log scale)",
       lwd = 2,
       cex.lab = 2,
       cex.axis = 2,
       cex.main  = 2)
  points(match_frac,C_CheckMatches,type = "l",lwd = 2, lty = 2,col=2)
  text(min(match_frac)+0.25,summary(C_CheckMatches)[2],
       label = expression(C[CheckMatches]),col=2,cex = 2)
  text(min(match_frac)+0.25,summary(C_CheckNonMatches)[5],
       label = expression(C[CheckNonMatches]),col=1,cex = 2)
  dev.off()
} 
