#!/usr/bin/env Rscript
{
  # initialize and set in initial parameters
  rm(list=ls())
  useRCE <-  (Sys.info()["sysname"] != "Darwin")
  whichDo <- c("fastBipartiteClust", "ml")
  justDoTrain = F
  HOLDOUT_SIZE <- 2000
  library(fastmatch)

  # read in for personal PC
  if(useRCE == F){
    setwd('~/Dropbox/Directory')
    con <- DBI::dbConnect(RSQLite::SQLite(), "./DataInputs/counts.sqlite")
  }

  # read in for RCE
  if(useRCE == T){
      rpath_conda = "./.conda/envs/Rtensorflow3/lib/R/library"
      options(repos=structure(c(CRAN="http://cran.r-project.org")), INSTALL_opts = c('--no-lock'))
    .libPaths(unique( c(.libPaths(),"./apps/R_version")) )
    if(justDoTrain == F){ con <- DBI::dbConnect(RSQLite::SQLite(), "./counts.sqlite") }

      try(tensorflow::use_condaenv("Rtensorflow3"),T)
      setwd( mainDir <- "~/" )
      require('tensorflow', lib.loc = rpath_conda)
      #devtools::install_github('cjerzak/LinkIt-software/LinkIt');library(LinkIt)
  }

  source("./Analysis/LinkOrgs_Helpers.R")

  if(justDoTrain == F){
  {
  print2("Establishing connection with SQL server...")
  library(RSQLite)

  ## list all tables
  tables <- dbListTables(con)

  ## exclude sqlite_sequence (contains table information)
  tables <- tables[tables != "sqlite_sequence"]


  ## create a data.frame for each table
  lDataFrames <- vector("list", length=length(tables)); for (i in seq(along=tables)) {
      lDataFrames[[i]] <- dbGetQuery(conn=con, statement=paste("SELECT * FROM '", tables[[i]], "'", sep=""))
  }
  }

  # processes the LinkedIn SQ tables
  {
  print2("Processing LinkedIn SQ tables...")
  my_data = (lDataFrames[[1]])#;rm(lDataFrames)
  save(my_data,file="./DataInputs/linkedIn_rawData.Rdata")

  load("./DataInputs/linkedIn_rawData.Rdata")
  my_data$raw_names <- my_data[,1]
  my_data[,1] <- paste("ALIAS___",my_data[,1],sep="")
  my_data[,2] <- paste("LINK___",my_data[,2],sep="")
  colnames(my_data)[1:3] <- c("from","to","weights")
  NUniqueURLs <- length(unique(my_data$to)) # 5950995
  NUniqueAliases <- length(unique(my_data$from)) # 15270027
  base10_exponent_NUniqueAliases <- lchoose(NUniqueAliases,2)
  base10_exponent_NUniqueAliases <- base10_exponent_NUniqueAliases/log(10,base=exp(1)) # change of base formula
  MeanAliasesPerURL <- mean( tapply(my_data$from,my_data$to,length) )# 2.878842
  MeanURLsPerAlias <- mean( tapply(my_data$to,my_data$from,length) )# 1.121935

  my_data <- my_data[my_data[,3] >= 5,] #TRIM RARELY USED ENTITIES
  #Pr(U_i=u, U_j=u| A_i, A_j)
  #rm( lDataFrames )
  save(my_data, file="./DataOutputs/linkedIn_dataProcessedForML.Rdata")

  #tmp_vec <- sapply(my_data$raw_names,function(ze){ any(strsplit(ze,split="")[[1]] %fin% letters,na.rm=T)})
  #my_data <- my_data[tmp_vec,]
  #my_data$raw_names <- textclean::replace_non_ascii(my_data$raw_names, remove.nonconverted=T)
  #my_data_WithNonLatin$raw_names <- textclean::replace_non_ascii(my_data_WithNonLatin$raw_names, remove.nonconverted=T)
  #save(my_data, file="./linkedIn_processedData_en.Rdata")
  #load("./linkedIn_processedData_en.Rdata")
  }

  # setup ml part
  if("ml" %in% whichDo){
    print2("Creating ML training data...")
      # get ml data
      {
        # preliminaries
        load("./linkedIn_dataProcessedForML.Rdata")
        log(sort( sapply(ls(),function(x){object.size(get(x))})) )

        # get and save importance weights
        {
          tmp_ <- paste(enc2utf8(my_data$raw_names),collapse=" ")
          strsplit_space_tokenizer <- function(x)unlist(strsplit(as.character(x), "[[:space:]]+"))
          control_list <- list(tokenize = strsplit_space_tokenizer,
                               removePunctuation = list(preserve_intra_word_dashes = TRUE),
                               stopwords = c(),
                               stemming = F,
                               wordLengths = c(1, Inf))
          idf_values <- tm::termFreq(tm::PlainTextDocument(tmp_),
                                     control = control_list); rm(tmp_)
          idf_values <- log(length(idf_values)/idf_values )
          idf_values_ <- idf_values
          idf_values_ <- as.vector(idf_values_);names(idf_values_)<-names(idf_values)
          idf_values <- idf_values_;rm(idf_values_)
          median_idf <- median(idf_values)

          getIDF <- function(name_vec){
            name_vec_orig <- name_vec;
            name_vec <- strsplit(name_vec,split=" ")
            lapply(name_vec,function(name_){
              wts_vec <- fastmatch::fmatch(c(name_),names(idf_values));
              wts_vec <- idf_values[wts_vec]
              wts_vec[is.na(wts_vec)] <-  median_idf
              return( wts_vec )
            })
          }
          getIDF(c("happy go","lucky in the futureafd"))

          # write idf values
          data.table::fwrite(cbind(names(idf_values),idf_values),file = "./DataOutputs/IDF_values.csv",append = F)
          rm(idf_values)
        }

        # set up data and compute Pr(O_i=O_j|A_i,A_j)
        {
          my_data <- my_data
          my_data <- my_data[!is.na(my_data$raw_names),]
          my_data <- my_data[!grepl(my_data$to,pattern="linkedin.com/company/profile-replaced"),] # drop replaced profiles
          getMask <- function(names_){ t(  sapply(names_, function(name_){c(rep(T, times = min(max_nCharsPerAlias,l_ <- nchar(name_) )),  rep(F, times = max(0,max_nCharsPerAlias - l_ )  ))}) )   }
          charIndicators <- c(); c_ <- 0; for(name_ in my_data$raw_names){
            c_ <- c_ + 1 ; if(c_ %% 20000 == 0){
              print2(sprintf("%s of %s done with for(name_ in my_data$raw_names)", c_, nrow(my_data)))
            }
            unique_chars <- unique(unlist(strsplit(name_,split="")))
            charIndicators <- c(charIndicators, setdiff(unique_chars, charIndicators)) }
          charIndicators <- as.data.frame( cbind(charIndicators,1:length( charIndicators )) )
          charIndicators[,2] <- f2n(charIndicators[,2])
          charIndicators[,1] <- enc2utf8(charIndicators[,1])
          data.table::fwrite(charIndicators,file = "./DataOutputs/charIndicators.csv")
          nchars <- nrow( charIndicators )

          library(fastmatch)
          URL_tab <- table(  my_data$to )
          URL_tab <- URL_tab[URL_tab>1]
          my_data$to_key <- as.integer( as.numeric( as.factor(my_data$to) )  )
          row.names( my_data ) <- NULL
          candidate_indices <- which( my_data$to %fin% names( URL_tab )  )
          my_data$to_key <- as.character( my_data$to_key )
          all_to_key <- as.character(my_data$to_key);
          all_to <- my_data$to;
          all_raw_names <- my_data$raw_names
          my_data_hasShares <- my_data[candidate_indices,]
          all_to_key_hasShares <- my_data_hasShares$to_key
          unique_all_to_key_hasShares <- sample(unique(all_to_key_hasShares))
          n_unique_hasShares <- length(unique_all_to_key_hasShares)

          # iterate over all links with multiple aliases linking to it
          counter__ <- 0; for(link_with_shares_key in unique_all_to_key_hasShares){
            counter__ <- counter__ + 1
            if(counter__ %% 2000 == 0){
              print2(sprintf("%s of %s done with for(link_with_shares_key in unique_all_to_key_hasShares):",
                        counter__, length(unique_all_to_key_hasShares)))
            }

            # data with > 1 match prob
            {
              #which_HasShareLink <- which(my_data_hasShares$to=="LINK___http://www.linkedin.com/company/ge")

              # find where link_with_shares_key occurs
              which_HasShareLink <- which(all_to_key_hasShares %fin% link_with_shares_key)

              # find all URLs that
              link_with_shares <- unique(my_data_hasShares$to[which_HasShareLink])
              my_data_base <- my_data_hasShares[which(my_data_hasShares$to %fin% link_with_shares),]

              # find all aliases that link to URL
              aliases_linking_to_link_with_share <- unique(my_data_hasShares$from[which_HasShareLink])
              #mean(my_data_hasShares[which_HasShareLink,] == my_data[my_data$to %fin% link_with_shares,])

              #  get all data for aliases linking to URL
              my_data_linking_to_link_with_share <- my_data[my_data$from %fin% aliases_linking_to_link_with_share,]

              PrUGivenA_list <- sapply(aliases_linking_to_link_with_share,function(from_){
                to_names <- my_data_linking_to_link_with_share$to[ from_i <- which(my_data_linking_to_link_with_share$from %fin% from_) ]
                to_ <- c(prop.table( my_data_linking_to_link_with_share$weights[ from_i ] ))
                names(to_) <- to_names
                list(  as.data.frame(t(to_)) )
                })
              rownames_PrUGivenA_list <- names(PrUGivenA_list)
              PrUGivenA_list <- do.call(plyr::rbind.fill,PrUGivenA_list)
              PrUGivenA_list[is.na(PrUGivenA_list)] <- 0
              row.names(PrUGivenA_list) <- rownames_PrUGivenA_list

              # grid is based on ALIAS
              pos_grid <- expand.grid(1:nrow(my_data_base),1:nrow(my_data_base))

              # drop a_i=a_j case
              #pos_grid <- pos_grid[pos_grid[,1]!=pos_grid[,2],]

              # ensure a_i,a_j for i<j to avoid duplicates
              pos_grid <- pos_grid[!duplicated(apply(apply(pos_grid,1,sort),2,function(zer){paste(zer,collapse="_")})),]

              PosRefDat <- cbind(my_data_base[pos_grid[,1],], my_data_base[pos_grid[,2],])

              if(nrow(PosRefDat) > 100){
               # check that this calc is okay
                #print2( dim( PosRefDat ) )
                rank_ <- log(PosRefDat[,grep(colnames(PosRefDat),pattern="weights")[1]]) +
                  log(PosRefDat[,grep(colnames(PosRefDat),pattern="weights")[2]])
                top50_ <- order(rank_, decreasing=T)[1:100]
                PosRefDat <- PosRefDat[top50_,]
                pos_grid <- pos_grid[top50_,]
                rm(rank_,top50_)
              }

              if(ncol(PrUGivenA_list) == 1){
                PosRefDat$matchProb <- (PrUGivenA_list[pos_grid[,1],] * PrUGivenA_list[pos_grid[,2],])
              }
              if(ncol(PrUGivenA_list) > 1){
                PosRefDat$matchProb <- rowSums(PrUGivenA_list[pos_grid[,1],] * PrUGivenA_list[pos_grid[,2],])
              }

              # GetPrSameOGivenAiAj("1&1 internet se","1&1 internet ag")
              # GetPrSameOGivenAiAj("1&1","1&1 internet, inc.")
              # View(PosRefDat[order(PosRefDat$matchProb,decreasing=T),])
              # mean(  my_data_base$from == rownames(PrUGivenA_list) )
              # mean(rownames(PrUGivenA_list) == my_data_base$from)
            }

            # data with 0 match prob
            {
              indices_NoSharedLinks <- sample( (1:nrow(my_data)), 2*nrow(PosRefDat)+1, prob = NULL )
              indices_NoSharedLinks <- indices_NoSharedLinks[ !(all_to_key[indices_NoSharedLinks] %fin%  unique(c(unique(my_data_linking_to_link_with_share$to),link_with_shares))) ]
              NegRefDat <- cbind(PosRefDat[sample(1:nrow(PosRefDat),length(indices_NoSharedLinks),replace=T),colnames(my_data)],
                                 my_data[indices_NoSharedLinks,])
              NegRefDat$matchProb <- 0

              # rename columns
              colnames( PosRefDat )[colnames(PosRefDat) == "raw_names"] <- c("name1","name2")
              colnames( NegRefDat )[colnames(NegRefDat) == "raw_names"] <- c("name1","name2")
              colnames( PosRefDat )[colnames(PosRefDat) == "to"] <- c("to1","to2")
              colnames( NegRefDat )[colnames(NegRefDat) == "to"] <- c("to1","to2")
              colnames( PosRefDat )[colnames(PosRefDat) == "to_key"] <- c("to_key1","key2")
              colnames( NegRefDat )[colnames(NegRefDat) == "to_key"] <- c("to_key1","key2")
              colnames( PosRefDat )[colnames(PosRefDat) == "weights"] <- c("weight1","weight2")
              colnames( NegRefDat )[colnames(NegRefDat) == "weights"] <- c("weight1","weight2")

              # write data, free up memory
              data.table::fwrite(PosRefDat, file = "./DataOutputs/PosMatches_mat.csv", append = counter__ > 1)
              data.table::fwrite(NegRefDat, file = "./DataOutputs/NegMatches_mat.csv", append = counter__ > 1)
              rm(NegRefDat, PosRefDat)
            }
            }

        # get important data summaries and drop big my_data
        max_nCharsPerAlias <- as.integer(  as.vector(  quantile( nchar(my_data$raw_names), prob = 0.95) ) ) # thinner tail
        max_nWords <- as.integer( ceiling( as.vector(  quantile(
            unlist(lapply(strsplit(sample(my_data$raw_names,50000),split=" "),length)), prob = 0.99) ) ) )
        max_nCharsPerWord <- as.integer( ceiling( as.vector(  quantile(
            unlist(lapply(strsplit(sample(my_data$raw_names,50000),split=" "),nchar)), prob = 0.99) ) ) )
        maskCharsKey_0based <- nchars

        rm(my_data)

        # generate holdout positive match sample
        PosMatches_mat <- data.table::fread(file = "./DataOutputs/PosMatches_mat.csv")
        nPositiveExamples <- nrow(PosMatches_mat) - HOLDOUT_SIZE
        hold_indices <- sample(which(PosMatches_mat$matchProb==1 & PosMatches_mat$name1!=PosMatches_mat$name2),HOLDOUT_SIZE)
        data.table::fwrite(PosMatches_mat[hold_indices,],file = "./DataOutputs/PosMatches_mat_hold.csv",append = F)
        data.table::fwrite(PosMatches_mat[-hold_indices,],file = "./DataOutputs/PosMatches_mat.csv",append = F)
        rm(PosMatches_mat)

        NegMatches_mat <- data.table::fread(file = "./DataOutputs/NegMatches_mat.csv")
        nNegativeExamples <- nrow(NegMatches_mat) - HOLDOUT_SIZE
        data.table::fwrite(NegMatches_mat[hold_indices,],file = "./DataOutputs/NegMatches_mat_hold.csv",append = F)
        data.table::fwrite(NegMatches_mat[-hold_indices,],file = "./DataOutputs/NegMatches_mat.csv",append = F)
        rm(NegMatches_mat)

        # remove all other objects
        rm( all_to_key,URL_tab,my_data_hasShares,all_to,
              all_to_key_hasShares,unique_all_to_key_hasShares,candidate_indices,
              PosMatches_mat_hold,NegMatches_mat_hold )

        # save checkpoint
        eval(parse(text =  sprintf('save(%s,file = "../../Documents/LinkOrgs-software/LinkOrgs/DataOutputs/linkedIn_processedData_checkpoint.Rdata")', paste(ls(),collapse=","))))
        }
    }
  }
  }

  # train ml model
  if("ml" %in% whichDo){
      print2("Performing ML Training..")
      # log(sort( sapply(ls(),function(x){object.size(get(x))})) )
      {
          # rm(list=ls()); setwd('~/Dropbox/Directory')
          # install.packages( "~/documents/LinkOrgs-software/LinkOrgs", repos = NULL, type = "source",force = F);
          # library(LinkOrgs)
          nPositiveExamples <- nrow( PosMatches_mat <- data.table::fread(file = "./DataOutputs/PosMatches_mat.csv") )
          nNegativeExamples <- nrow( NegMatches_mat <- data.table::fread(file = "./DataOutputs/NegMatches_mat.csv") )

          # scramble
          set.seed(19591L); PosMatches_mat <- PosMatches_mat[sample(1:nrow(PosMatches_mat), nrow(PosMatches_mat)),]
          set.seed(19592L); NegMatches_mat <- NegMatches_mat[sample(1:nrow(NegMatches_mat), nrow(NegMatches_mat)),]

          # BUILD
          print2("Building ML model..")
          BuildText <- deparse1(BuildML,collapse="\n")
          BuildText <- gsub(BuildText,pattern="function \\(\\)",replace="")
          eval(parse( text = BuildText ))

          # TRAIN
          if(retrain <- T){
            print2("Training ML model..")
            TrainText <- deparse1(TrainML,collapse="\n")
            TrainText <- gsub(TrainText,pattern="function \\(\\)",replace="")
            eval(parse( text = TrainText ))
          }

          # RESTORE
          print2("Restoring ML model..")
          RestoreText <- deparse1(RestoreML,collapse="\n")
          RestoreText <- gsub(RestoreText,pattern="function \\(\\)",replace="")
          eval(parse( text = RestoreText ))
       }

      # perform transfer learning
      print2("Performing transfer learning...")
      source("./Analysis/LinkOrgs_TransferLearning.R")
  }

  if("fastBipartiteClust" %in% whichDo){
    print2("Starting bipartite clustering...")
    source( "./Analysis/LinkOrgs/DoBipartite.R"  )
  }
}
