#!/usr/bin/env Rscript
# do optimization
for(i in i_:nSGD_model){
  t0 <- Sys.time()
  # save analytics with model checkpoints
  #if( i %in% round(nSGD_model / 1:4)  ){
  if( (LastCond <- i %% 100 == 0)  | (CheckpointCounter <- (i %in% round(nSGD_model / 1:4) ))){
    outSampCounter <- outSampCounter + 1
    print2( sprintf("Saving model at iter %s of %s", i, nSGD_model) )
    LastCond <- LastCond & (!CheckpointCounter)

    # also save optimizer state
    eq$tree_serialise_leaves(sprintf("%s%s_i%s.eqx", SaveDir, SaveName, "last"),
                             list(ModelList, StateList, opt_state))
    zip(zipfile = sprintf("%sAnalysisR_%s.zip", SaveDir, SaveName), files = "./Analysis")

    # recover trained model
    if(T == F){
        #newDate <-  "2024-02-15"; oldDate <- "2024-02-13"; SaveDir <- gsub(SaveDir,pattern=newDate,replace=oldDate);SaveName <- gsub(SaveName,pattern=newDate,replace=oldDate)
        ModelList_recovered <- eq$tree_deserialise_leaves(
                  sprintf("%s%s_i%s.eqx", SaveDir, SaveName, ReCoverAt <- "last"),
                  list(ModelList, StateList, opt_state) )
        opt_state_recovered <- ModelList_recovered[[3]];
        StateList_recovered <- ModelList_recovered[[2]];
        ModelList_recovered <- ModelList_recovered[[1]]

        # setup for checkpointed training or inference
        StateList <- StateList_recovered; ModelList <- ModelList_recovered;

        # if restarting optimizer
        opt_state <- opt_state_recovered
        i_ <- np$array( opt_state[[4]][[2]]$count)
        rm(ModelList_recovered,StateList_recovered,opt_state_recovered)

        # checks
        # opt_state[[4]]; opt_state_recovered[[4]]
        # ModelList[[3]]$weight

      }
  }

  i_ <- i; itertimer <- Sys.time()
  if(i %% 5 == 0){  print(i); gc(); py_gc$collect()  }

  # get full batch
  {
    PosMatches_mat_ <-  PosDataset_iterator$`next`()
    NegMatches_mat_ <-  NegDataset_iterator$`next`()

    # end of iterator checks
    if(PosMatches_mat_$shape$as_list()[[1]] != batchSize_pos_total){
      print2("Resetting positive iterator..."); resetPosIteratorCounter <- resetPosIteratorCounter + 1
      PosMatches_mat_ <- ( PosDataset_iterator <- reticulate::as_iterator( PosDataset ) )$`next`()
    }
    if(NegMatches_mat_$shape$as_list()[[1]] != batchSize_neg_total){
      print2("Resetting negative iterator..."); resetNegIteratorCounter <- resetNegIteratorCounter + 1
      NegMatches_mat_ <- ( NegDataset_iterator <- reticulate::as_iterator( NegDataset ) )$`next`()
    }

    # process
    NegMatches_mat_ <- np$array(NegMatches_mat_); PosMatches_mat_ <- np$array(PosMatches_mat_)
    colnames( PosMatches_mat_ ) <- colnames( NegMatches_mat_ ) <-  DatasetColnames

    # process names (encodings and extra "\s)
    PosMatches_mat_[,"name1"] <- gsub(enc2utf8(as.character2(PosMatches_mat_[,"name1"])), pattern="\\\"\\\"",replace="\\\"")
    PosMatches_mat_[,"name2"] <- gsub(enc2utf8(as.character2(PosMatches_mat_[,"name2"])), pattern="\\\"\\\"",replace="\\\"")

    NegMatches_mat_[,"name1"] <- gsub(enc2utf8(as.character2(NegMatches_mat_[,"name1"])),pattern="\\\"\\\"",replace="\\\"")
    NegMatches_mat_[,"name2"] <- gsub(enc2utf8(as.character2(NegMatches_mat_[,"name2"])),pattern="\\\"\\\"",replace="\\\"")
  }

  # initial test of fxn
  if(i == 1 & T == T){
    nTest <- min(c(nrow(PosMatches_mat_),10))
    # unlist(PosMatches_mat_[,"name1"])[1:nTest]
    # charIndicators[c(245,259,257)+1]
    # xt <- GetList(name_raw = unlist(PosMatches_mat_[,"name1"])[1:nTest], MaxUqWords = MaxUqWords_AdvSel)
    # truth <- jnp$array(as.matrix(runif(nTest,0,1))); inference <- F
    # unlist(PosMatches_mat_[,"name1"])[1:nTest]

    GetLoss( ModelList,
      GetList(name_raw = unlist(PosMatches_mat_[,"name1"])[1:nTest], MaxUqWords = MaxUqWords_AdvSel), # xt
      jnp$array(as.matrix(runif(nTest/2,0,1))), # truth
      StateList, MPList, F)
    gc(); py_gc$collect()
  }

  # get non-adversarial batch
  PosMatches_mat_nonAdv <- NegMatches_mat_nonAdv <- c(); if(adv_frac < 1){
    PosMatches_mat_nonAdv <- PosMatches_mat_[1:nNonAdversarial_pos,]
    NegMatches_mat_nonAdv <- NegMatches_mat_[1:nNonAdversarial_neg,]
  }

  if(adv_frac == 0){
    PosMatches_mat_ <- PosMatches_mat_nonAdv;
    NegMatches_mat_ <- NegMatches_mat_nonAdv
  }

  # adversarial selection
  if( adv_frac > 0 ){
    # adversarial - positive examples - search over fixed pairs
    {
      xt <- GetList(name_raw = c(unlist(PosMatches_mat_[,"name1"]),
                                    unlist(PosMatches_mat_[,"name2"])),
                       MaxUqWords = MaxUqWords_AdvSel)
      #inference = F;  truth <- jnp$array(as.matrix(sample(c(0,1),30L,replace=T)))
      t1 <- Sys.time(); if( i == 1 ){ print2(sprintf("At first Adv GetMatchProb_jit(); Data input shapes: [%s] and [%s]", paste(unlist(xt$CINDICES$shape), collapse = ", "), paste(unlist(xt$WINDICES$shape), collapse = ", ") )) }
      tmp_j <-  np$array( GetMatchProb_jit(
                                  ModelList,
                                  xt, # xt
                                  StateList, MPList, F)[[1]] )

      # select lowest prob treated matches
      #plot( tmp_j[ order(tmp_j,decreasing = F)] )
      PosMatches_mat_ <- as.data.frame( PosMatches_mat_[order(tmp_j,decreasing = F)[1:nAdversarial_pos],] )

      # rbind adversarial and non-adversarial matches
      PosMatches_mat_ <- rbind(PosMatches_mat_, PosMatches_mat_nonAdv)
    }

    # adversarial - negative examples - search over fixed pairs
    {
      xt <- GetList(name_raw = c(unlist(NegMatches_mat_[,"name1"]),unlist(NegMatches_mat_[,"name2"])),
                       MaxUqWords = MaxUqWords_AdvSel)
      tmp_j <- np$array(   GetMatchProb_jit( ModelList,
                                             xt, # xt
                                             StateList, MPList, F)[[1]] )

      # select highest prob neg matches
      # plot( tmp_j[order(tmp_j,decreasing = T)] )
      NegMatches_mat_ <- as.data.frame( NegMatches_mat_[order(tmp_j,decreasing = T)[1:nAdversarial_neg],] )
      NegMatches_mat_ <- rbind(NegMatches_mat_, NegMatches_mat_nonAdv)
      rm(tmp_j, NegMatches_mat_nonAdv, PosMatches_mat_nonAdv)
    }
  }

  # update step
  {
    # parse data from iter
    xt <- GetList(name_raw = c( c(unlist(PosMatches_mat_[,"name1"])), unlist(NegMatches_mat_[,"name1"]), # names 1
                                c(unlist(PosMatches_mat_[,"name2"])), unlist(NegMatches_mat_[,"name2"]) ), # names 2
                  MaxUqWords = MaxUqWords_Train)
    if(T == F){ # checks
      inference = F; truth <- jnp$array(as.matrix(c(f2n(as.character2(PosMatches_mat_[,"matchProb"])), f2n(as.character2(NegMatches_mat_[,"matchProb"])))))
    }
    t1 <- Sys.time(); if( i == 1 ){ print2(sprintf("At first gradLoss_jax(); Data input shapes: [%s] and [%s]",
                                                   paste(unlist(xt$CINDICES$shape), collapse=", "), paste(unlist(xt$WINDICES$shape), collapse=", ") )) }
    GradientUpdatePackage <- try(GradAndLossAndAux(
                                            MPList[[1]]$cast_to_compute(ModelList),
                                            xt,
                                            jnp$array(as.matrix(c(f2n(as.character2(PosMatches_mat_[,"matchProb"])), f2n(as.character2(NegMatches_mat_[,"matchProb"]))))), # truth
                                            StateList, MPList, F), T)
    if(class(GradientUpdatePackage) == "try-error"){ print2( "Failure at GradientUpdatePackage"  ); print( GradientUpdatePackage ) }
    if(class(GradientUpdatePackage) != "try-error"){
      ## unscale gradients and update scaling factor
      AllFinite_DontAdjust <- jnp$array(T); if(as.character(computeDtype$dtype)=="float16"){
        GradientUpdatePackage[[1]][[1]]  <-  MPList[[2]]$unscale( GradientUpdatePackage[[1]][[1]] ) # value

        # unscale + adjust loss scale is some non-finite or NA
        if(!"Map2Zero" %in% ls()){
          Map2Zero <- eq$filter_jit(function(input){
            jax$tree_map(function(x){ jnp$where(jnp$isnan(x), jnp$array(0), x)}, input) })
          AllFinite <- jax$jit( jmp$all_finite )
        }
        GradientUpdatePackage[[2]] <- Map2Zero( MPList[[2]]$unscale( GradientUpdatePackage[[2]] ) )  # this recasts to param
        AllFinite_DontAdjust <- AllFinite( GradientUpdatePackage[[2]] )  & jnp$squeeze(jnp$array(!is.infinite(GradientUpdatePackage[[1]][[1]]$tolist())))
        MPList[[2]] <- MPList[[2]]$adjust( AllFinite_DontAdjust  )
      }

      # update state
      StateList_tmp <- GradientUpdatePackage[[1]][[2]]
      GradientUpdatePackage[[1]] <- GradientUpdatePackage[[1]][[1]]

      # update loss
      myLoss_fromGrad <- GradientUpdatePackage[[1]]$tolist()
      GradientUpdatePackage <- GradientUpdatePackage[[2]];
      GradientUpdatePackage <- eq$partition(GradientUpdatePackage, eq$is_inexact_array)
      GradientUpdatePackage_aux <- GradientUpdatePackage[[2]]; GradientUpdatePackage <- GradientUpdatePackage[[1]]

      # update parameters if passing thru all checks
      UpdateParametersCond <- !is.na(myLoss_fromGrad) & (np$array(AllFinite_DontAdjust))
      if(! UpdateParametersCond ){
        print("Warning: Not updating parameters!")
        if(!np$array(AllFinite_DontAdjust)){ print("Inf in gradients!") }
        if(is.na(myLoss_fromGrad)){ print("Inf in gradients!") }
      }
      if( UpdateParametersCond ){
        ExecuteUpdateCounter <- ExecuteUpdateCounter + 1

        # updates + setup for net iteration
        GradientUpdatePackage <- jit_get_update( # gets updates_and_opt_state
          updates = GradientUpdatePackage,
          state = opt_state,
          params = eq$partition(ModelList, eq$is_array)[[1]])
        opt_state <- GradientUpdatePackage[[2]]
        GradientUpdatePackage <- eq$combine(GradientUpdatePackage[[1]],
                                            GradientUpdatePackage_aux)

        # perform update
        ModelList <- eq$combine(
                jit_apply_updates(params = eq$partition(ModelList, eq$is_array)[[1]],
                                  updates = GradientUpdatePackage),
                eq$partition(ModelList, eq$is_array)[[2]])

        StateList <- StateList_tmp
        rm(ModelParams_GlobalPartitioned, StateList_tmp, GradientUpdatePackage)
      }

      # plotting sequence (do this after all parameter + state updates complete)
      if(i_ > 10 & i %% 4 == 0){  try({plot(rank(na.omit(in_loss_vec))); points(smooth.spline(rank(na.omit(in_loss_vec))),type = "l",lwd=3)},T) }
    } # end if(class(GradientUpdatePackage) != "try-error"){

    # save statistics
    in_loss_vec[i] <- as.numeric( myLoss_fromGrad )
    if(is.na(as.numeric(myLoss_fromGrad))){print(as.numeric(myLoss_fromGrad))}

    # print results
    if(i %% 2 == 0){  print2( sprintf("Iter: %s -- Loss: %.3f (%.1f%%) -- Total (s): %.2f -- Grad (s): %.2f",
                                      i, myLoss_fromGrad,
                                      100*(1-rank(in_loss_vec[1:i])[i]/i),
                                      (Sys.time()-t0)[1],
                                      (Sys.time()-t1)[1] ) )   }
  } # end training loop
}

