{
  bytes_feature <- function(value){
    tf$train$Feature(bytes_list=tf$train$BytesList(value=list(value$numpy())))
  }

  serialize_example <- function(mat){
    feature = dict(
      'shape' = bytes_feature(tf$io$serialize_tensor(nFeatures)),
      'data' = bytes_feature(tf$io$serialize_tensor(mat))
    )
    example_proto <- tf$train$Example(features = tf$train$Features(feature = feature))
    return( example_proto$SerializeToString() )
  }

  write_to_tfrecord <- function(mat, file){
    tf_record_writer = tf$io$TFRecordWriter( file ) #create a writer that'll store our data to disk
    for(jr in 0L:(mat$shape[[0]]-1L)){
      if( (jr %% 10000 == 0) | jr == 0){ print2(sprintf("At tfrecord write %s of %s", jr, mat$shape[[0]]-1L) ) }
      tf_record_write_output <- serialize_example(mat[jr,])
      tf_record_writer$write( tf_record_write_output  )
    }
    tf_record_writer$close()
  }

  parse_single_example_fxn <- function(example_proto){
    # Define the features to be extracted.
    feature_description = list(
      'shape' = tf$io$FixedLenFeature(list(), tf$string),
      'data' = tf$io$FixedLenFeature(list(), tf$string)
    )
    # Parse the input `tf.train.Example` proto using the dictionary above.

    example = tf$io$parse_single_example(example_proto, feature_description)
    shape = tf$io$parse_tensor(example[['shape']], out_type = tf$int32)
    data = tf$io$parse_tensor(example[['data']], out_type = tf$string)
    data = tf$reshape(data, shape)
    return(data)
  }

  read_from_tfrecord <- function(file, batchSize, TfRecords_BufferScaler = 10L){
    raw_dataset = tf$data$TFRecordDataset( file )
    parsed_dataset = raw_dataset$map( parse_single_example_fxn )
    parsed_dataset <- parsed_dataset$shuffle(buffer_size = tf$constant(as.integer(TfRecords_BufferScaler*batchSize), dtype=tf$int64),
                               reshuffle_each_iteration = T)
    parsed_dataset <- parsed_dataset$batch( batchSize )
    return( parsed_dataset )
  }

  # Load into memory positive examples + write to TFRecord
  if( resaveTFRecord ){
    print2("Resaving tfrecord...")
    PosMatches_mat <- data.table::fread(file = "./DataOutputs/PosMatches_mat.csv")
    nFeatures <- 11L #ncol(PosMatches_mat)
    PosMatches_mat <- tf$constant( as.matrix(PosMatches_mat) )
    write_to_tfrecord(mat = PosMatches_mat, file = './DataOutputs/PosExamples.tfrecord')
    rm( PosMatches_mat ); gc(); py_gc$collect()

    # Load and write negative data
    NegMatches_mat <- data.table::fread(file = "./DataOutputs/NegMatches_mat.csv")
    NegMatches_mat <- tf$constant( as.matrix(NegMatches_mat) )
    write_to_tfrecord(mat = NegMatches_mat, file = './DataOutputs/NegExamples.tfrecord')
    rm ( NegMatches_mat )
  }

  if(T == F){
    # Read from TFRecord -- testing mode
    batchSize_posPol <- batchSize_negPool <-  256L
    PosDataset <- read_from_tfrecord(file = './DataOutputs/PosExamples.tfrecord', batchSize = batchSize_posPool)
    NegDataset <- read_from_tfrecord(file = './DataOutputs/NegExamples.tfrecord', batchSize = batchSize_negPool)

    # Setup iterator
    PosDataset_iterator <- reticulate::as_iterator( PosDataset )
    NegDataset_iterator <- reticulate::as_iterator( NegDataset )
    PositiveBatch <- reticulate::iter_next( PosDataset_iterator )
    NegativeBatch <- reticulate::iter_next( NegDataset_iterator )
    NegativeBatch$shape
    PositiveBatch$shape
  }
  gc()

  if( StartIterator ){
    print2("Restablishing conection with tfrecord")
    # load in link data
    # load("./linkedIn_dataProcessedForML.Rdata"); my_data <- my_data[,c("raw_names","to")]
    # all_raw_names <- enc2utf8(my_data$raw_names)
    # all_raw_to <- enc2utf8(my_data$to);

    # Read from TFRecord
    PosDataset <- read_from_tfrecord(file = './DataOutputs/PosExamples.tfrecord', batchSize = batchSize_pos_total)
    NegDataset <- read_from_tfrecord(file = './DataOutputs/NegExamples.tfrecord', batchSize = batchSize_neg_total)

    DatasetColnames <- colnames(  data.table::fread(file = "./DataOutputs/NegMatches_mat_hold.csv") )
    as.character2 <- function(x){ unlist(  lapply(x, as.character) ) }

    # setup iterators
    PosDataset_iterator <- reticulate::as_iterator( PosDataset )
    NegDataset_iterator <- reticulate::as_iterator( NegDataset )
  }

}
