#!/usr/bin/env Rscript

print2("Wrapping up LinkedIn training data creation..")
{
  # get out of sample ml results
  {
    NegMatches_mat_hold <- as.data.frame( data.table::fread("./DataOutputs/NegMatches_mat_hold.csv"))
    #NegMatches_mat_hold <- NegMatches_mat_hold[sample(1:nrow(NegMatches_mat_hold),30),]

    PosMatches_mat_hold <- as.data.frame( data.table::fread("./DataOutputs/PosMatches_mat_hold.csv"))
    #PosMatches_mat_hold <- PosMatches_mat_hold[sample(1:nrow(PosMatches_mat_hold),30),]

    # name1 = unlist(PosMatches_mat_hold[,"name1"]); name2 = unlist(PosMatches_mat_hold[,"name2"])
    stringdist_pos <- stringdist::stringdist(a = unlist(PosMatches_mat_hold[,"name1"]), b = unlist(PosMatches_mat_hold[,"name2"]), q = 2)
    stringdist_neg <- stringdist::stringdist(a = unlist(NegMatches_mat_hold[,"name1"]), b = unlist(NegMatches_mat_hold[,"name2"]), q = 2)
    PosProbMat_out <- GetMatchProb_BigBatch( name1 = unlist(PosMatches_mat_hold[,"name1"]),
                                             name2 = unlist(PosMatches_mat_hold[,"name2"]),
                                             nBatch_BigBatch = (nBatch_BigBatch <- 50L) )
    NegProbMat_out <- GetMatchProb_BigBatch( name1 = unlist(NegMatches_mat_hold[,"name1"]),
                                             name2 = unlist(NegMatches_mat_hold[,"name2"]),
                                             nBatch_BigBatch = nBatch_BigBatch )
    ks.test(stringdist_pos, stringdist_neg)$statistic
    ks.test(c(PosProbMat_out$matchprob), c(NegProbMat_out$matchprob))$statistic
    summary( NegProbMat_out$matchprob ); summary( PosProbMat_out$matchprob )
    plot(density(NegProbMat_out$matchprob),xlim = c(0,1))
    points(density(PosProbMat_out$matchprob), type = 'l', lty = 3)
    PosMatches_mat_hold <- cbind(PosMatches_mat_hold, "matchProb_est"=PosProbMat_out$matchprob)
    NegProbMat_out <- cbind(NegProbMat_out, "matchProb_est"=NegProbMat_out$matchprob)

    View( head( PosMatches_mat_hold[order(PosProbMat_out$matchprob),c("name1",'name2','matchProb_est')], 100) )
    View( tail( PosMatches_mat_hold[order(PosProbMat_out$matchprob),c("name1",'name2','matchProb_est')], 300) )

    View( head( NegProbMat_out[order(NegProbMat_out$matchprob),c("name1",'name2','matchProb_est')], 20) )
    View( tail( NegProbMat_out[order(NegProbMat_out$matchprob),c("name1",'name2','matchProb_est')], 20) )
    MeanTop20Neg_prob <- mean(tail( NegProbMat_out[order(NegProbMat_out$matchprob),c("name1",'name2','matchProb_est')], 20)[[3]])
    View( PosProbMat_out[abs(PosProbMat_out$matchprob - MeanTop20Neg_prob)<0.02,] )


    # get embeddings for LinkedIn names
    # first re-initialize target model
    if(T == F){
      setwd('~/Dropbox/Directory'); options(timeout = max(60*5, getOption("timeout")))
      ml_version <- "v1"
      DownloadFolder <- "./DataOutputs"
      ModelLoc <- gsub(ModelZipLoc <- sprintf('%s/Model_%s.zip', DownloadFolder, ml_version ),
                       pattern = "\\.zip", replace = "")
      WeightsLoc <- sprintf('%s/ModelWeights_%s.eqx', DownloadFolder, ml_version)
      CharIndicatorsLoc <- sprintf('%s/CharIndicatorsLoc.csv', DownloadFolder)

      if( !file.exists( ModelZipLoc ) | !file.exists( WeightsLoc) ){
        if(ml_version == "v0"){
          ModelURL <- "https://www.dropbox.com/scl/fi/1uz9pmw466kfnwwdrinpz/Archive.zip?rlkey=ia7d0nu8syixav8qlnug8gwpt&dl=0"
          WeightsURL <- "https://www.dropbox.com/scl/fi/7w0fc4vdw372a4jkkwpfp/ModelWeights_v0.eqx?rlkey=5rjppey7i4ymllne5gitxt80x&dl=0"
        }
        if(ml_version == "v1"){
          ModelURL <- "https://www.dropbox.com/scl/fi/4evf6d6t2804hpx4i4al3/AnalysisR_LinkOrgsBase_29PT9M_2024-02-12.zip?rlkey=08tet5hd1v178j9r6mvv447f8&dl=0"
          WeightsURL <- "https://www.dropbox.com/scl/fi/b07rk4gjnqmows5rwsgkd/LinkOrgsBase_29PT9M_2024-02-12_ilast.eqx?rlkey=t16hqkv2wwpivd28blak5opcz&dl=0"
        }

        # process URLs
        ModelURL <- LinkOrgs::dropboxURL2downloadURL(ModelURL);
        WeightsURL <- LinkOrgs::dropboxURL2downloadURL(WeightsURL)

        # download weights
        download.file( WeightsURL, destfile = WeightsLoc )

        # download and unzip model
        download.file( ModelURL, destfile = ModelZipLoc )
        unzip(ModelZipLoc, exdir = ModelLoc)

        # download characters & save
        charIndicators <- LinkOrgs::url2dt("https://www.dropbox.com/scl/fi/1jh8nrwsucfzj2gy9rydy/charIndicators.csv.zip?rlkey=wkhqk9x3550l364xbvnvnkoem&dl=0")
        data.table::fwrite(charIndicators, file = CharIndicatorsLoc)
      }

      # build model
      print("Re-building ML model...")
      trainModel <- F; AnalysisName <- "LinkOrgs"
      charIndicators <- as.matrix( data.table::fread(file = CharIndicatorsLoc) )
      source( sprintf('%s/Analysis/LinkOrgs_Helpers.R', ModelLoc), local = T )
      source( sprintf('%s/Analysis/JaxTransformer_Imports.R', ModelLoc), local = T )
      source( sprintf('%s/Analysis/JaxTransformer_BuildML.R', ModelLoc), local = T )
      source( sprintf('%s/Analysis/JaxTransformer_TrainDefine.R', ModelLoc), local = T )

      # obtain trained weights
      print("Applying trained weights...")
      ModelList <- eq$tree_deserialise_leaves( WeightsLoc,
                                               list(ModelList, StateList, opt_state) )
      StateList <- ModelList[[2]]; ModelList <- ModelList[[1]]
    }
    print( sprintf("Matching via name representations from match-calibrated Transformer models [%s]...",ml_version) )
    for(clustering in c("markov", "bipartite")){
    #for(clustering in c("bipartite")){
      print( sprintf("On clustering embeddings type: %s",clustering) )
      if(clustering == "bipartite"){
        load("./DataOutputs/directory_data_bipartite_thresh40/LinkIt_directory_bipartite.Rdata")
      }
      if(clustering == "markov"){
        load("./DataOutputs/directory_data_markov/LinkIt_directory_markov.Rdata")
      }

      # save linkedIn database names
      ar_network <- GetAliasRep_BigBatch( tolower(directory[,"alias_name"]),
                                          nBatch_BigBatch = 256L)
      colnames(ar_network) <- paste("D",1:ncol(ar_network),sep="")
      row.names(ar_network) <- directory[,"alias_name"]
      if(nrow(ar_network) != nrow(directory)){
        stop("Row dim mismatch!")
      }

      gc(); py_gc$collect()
      # ar_network2 <- data.table::fread("~/Dropbox/Directory/DataOutputs/Directory_LinkIt_bipartite_Embeddings_v0.csv.gz"); clustering <- "bipartite"; ml_version <- "v0"
      data.table::fwrite(round(ar_network,4),
                         file = sprintf("./DataOutputs/Directory_LinkIt_%s_Embeddings_%s.csv.gz",
                                        clustering, ml_version),
                         compress = "auto",
                         row.names = T , quote = T)
    }


    bestMatch_ml <- tapply(1:nrow(ProbMat_out),ProbMat_out$i1,function(zer){
      red_ <- PosProbMat_out[zer,]
      red_$i2[which.max(red_$matchprob)]  })

    # concerned about mis-predicting 1 character names
    #getProbMat(c("apple corporation","JP Morgan", "JP Morgan Chase Commercial Banking"), c("apple","general motors","JP Morgan Chase Asset Management"), training = F)
    #FastFuzzyMatch(x = cbind(name = x_,"id"=1:length(x_)), y = cbind(name = y_,"id"=1:length(y_)), by = "name", MaxDist = 10)
    # step a
    x_ <- c("wells fargo bank", "jp morgan chase bank", "goldman sachs",
            c("wells fargo advisors","washington mutual", "saks fifth avenue"))
    ma <- GetMatchProb_BigBatch( x_[1:3], x_[4:6] )

    # step b1
    mb1 <- GetMatchProb_BigBatch(x_, y_ <- c("wells fargo bank, na",
                                          "wells fargo mortgage",
                                          "jp morgan bank, n.a.",
                                          "washington mutual",
                                          "高盛",
                                          "goldman sachs & co" ))

    # step b2
    mb2  <- GetMatchProb_BigBatch(y_,  c("wells fargo services",
                                     "jp morgan bank, n.a.",
                                     "washington mutual",
                                     "saks incorporated", "", ""))

    Rescale_0_1 <- function(v, min_v, max_v){ (v - min_v) / (max_v - min_v) }
    min_v <- min(c(ma$matchprob,mb1$matchprob, mb2$matchprob))
    max_v <- max(c(ma$matchprob,mb1$matchprob, mb2$matchprob))
    ma$matchprob <-  Rescale_0_1( ma$matchprob, min_v, max_v  )
    mb1$matchprob <-  Rescale_0_1( mb1$matchprob, min_v, max_v  )
    mb2$matchprob <-  Rescale_0_1( mb2$matchprob, min_v, max_v  )

    PosMatches_mat_hold$to_key2  <- PosMatches_mat_hold$key2
    FuzzyResults <- LinkOrgs::FastFuzzyMatch(
      x = PosMatches_mat_hold[,c("name1","to1","to_key1")],
      y = PosMatches_mat_hold[,c("name2","to2","to_key2")],
      by.x = "name1",by.y = "name2",
      MaxDist = 20., qgram = 3)
    diag_fuzzy <- FuzzyResults[FuzzyResults$to_key1==FuzzyResults$to_key2,]$stringdist
    offDiag_fuzzy <- FuzzyResults[FuzzyResults$to_key1 != FuzzyResults$to_key2,]$stringdist
    print2(  sprintf( "KS Statistic: %.5f",ks.test(c(offDiag_fuzzy), diag_fuzzy)$statistic) )

    # get matrices
    PredMat <- cbind(PosMatches_mat_hold[,c("name1","to1")],
                     PosMatches_mat_hold[bestMatch_ml,c("name2","to2")])[,c("name1","name2","to1","to2")]
    PredMat_correct <- PredMat[PredMat$to1 == PredMat$to2,]
    PredMat_incorrect <- PredMat[PredMat$to1 != PredMat$to2,]

    # get representation values for matches/non-matches
    diag_ <- ProbMat_out[ProbMat_out$i1==ProbMat_out$i2,]$matchprob
    offDiag_ <- ProbMat_out[ProbMat_out$i1 != ProbMat_out$i2,]$matchprob
    print2(  sprintf( "KS Statistic: %.5f",ks.test(c(offDiag_), diag_)$statistic) )

    # obtain overall results
    truth_ <- cbind(PosMatches_mat_hold$name1,PosMatches_mat_hold$name2)
    print2( sprintf("Out Sample Accuracy: %.3f",  mean(PosMatches_mat_hold$to1 == PosMatches_mat_hold$to2[bestMatch_ml])))
  }

  # contrast plot
  {
    # ADD THE COMPARISON WITH FUZZY MATCHING
    pdf("~/Downloads/TransformerVectorCors.pdf")
    dp_ <- density(diag_); dn_<-density(offDiag_)
    dn_$y <-  dn_$y / max( dn_$y )
    dp_$y <-  dp_$y / max( dp_$y )
    par(mar=c(4,5,5,1)); plot( dn_,
                               lwd=2,
                               xlim = c(min(dn_$x,dp_$x),max(dn_$x,dp_$x)),
                               ylim = c(0,max(dn_$y,dp_$y)*1.2),col="gray",log="",
                               main = "Predicted Match Probabilities",cex.lab = 2,
                               xlab = "Predicted Probability",cex.main = 2)
    points(dp_ ,lwd=2,type="l" )
    text(dp_$x[which.max(dp_$y)],max(dp_$y)+max(dp_$y)*.05,labels = "Matches",cex=1.5)
    text(dn_$x[which.max(dn_$y)],max(dn_$y)+max(dp_$y)*.05,labels = "Non-matches",cex=1.5,col="gray")
    dev.off()
  }

  # case study plot
  if(T == T){
    #l1_i <- getList(name_raw = enc2utf8( PosMatches_mat_hold$name1 ) )
    n1_vec <- enc2utf8(c("oracle corporation",
                         "apple co",
                         "fannie mae",
                         "苹果公司", # way to way apple in chinese
                         #"mit",
                         "united nations"))
    n2_vec <- enc2utf8(c("oracle",
                         "apple",
                         "federal national mortgage ass.",
                         "苹果股份有限公司", # way to way apple in chinese
                         #"massachusetts institute of technology",
                         "united nations human rights council"))
    VecsA  <- as.matrix(getRepresentation(
      CINDICES = (l1_i<-getList(name_raw = enc2utf8( n1_vec ) ))$CINDICES,
      WINDICES = l1_i$WINDICES,
      TRAINING = tf$constant(F,tf$bool)))
    VecsB  <- as.matrix(getRepresentation(
      CINDICES = (l1_i<-getList(name_raw = enc2utf8( n2_vec ) ))$CINDICES,
      WINDICES = l1_i$WINDICES,
      TRAINING = tf$constant(F,tf$bool)))
    VecsA_ref  <- as.matrix(getRepresentation(
      CINDICES = (l2_i<-getList(name_raw = enc2utf8( PosMatches_mat_hold$name1 ) ))$CINDICES,
      WINDICES = l2_i$WINDICES,
      TRAINING = tf$constant(F,tf$bool)))
    VecsB_ref  <- as.matrix(getRepresentation(
      CINDICES = (l2_i<-getList(name_raw = enc2utf8( PosMatches_mat_hold$name2 ) ))$CINDICES,
      WINDICES = l2_i$WINDICES,
      TRAINING = tf$constant(F,tf$bool)))
    pdf("~/Downloads/PCFigDistances.pdf",
        family = "CNS1") # traditional chinese
    #family="GB1") #  # traditional chinese
    {
      prcomp_ <- prcomp(scale(rbind(VecsA_ref,VecsB_ref)))
      par(mar=c(5,5,3,1))
      samp_ <- 1:nrow(VecsA)
      plot( prcomp_allPredicts <- predict(prcomp_,rbind(VecsA,VecsB)),
            xlim = summary(prcomp_allPredicts[,1])[c(1,6)]*1.5,
            ylim = (ylim_ <- summary(prcomp_allPredicts[,2])[c(1,6)]*1.5),
            cex=0, xlab = "Principal Component 1", ylab = "Principal Component 2",cex.lab = 2)
      xy1 <- predict(prcomp_,VecsA)[samp_,1:2];
      xy2 <- predict(prcomp_,VecsB)[samp_,1:2]
      d12 <- rowSums( (xy1-xy2)^2)
      col_vec <- gray.colors(length(d12),start=0,end=0.6); col_vec <- col_vec[order(d12,decreasing = F)]
      col_vec[] <- "black"
      points( xy1,pch = 1:length(col_vec),cex=1.5,col=col_vec)
      points( xy2,pch = 1:length(col_vec),cex=1.5,col=col_vec)
      text( xy1[,1],xy1[,2]+(ep_<-diff(ylim_)*0.01),
            labels = n1_vec[samp_],cex=(cex_<-1),font=165,col=col_vec)
      text( xy2[,1],xy2[,2]+(-ep_),
            labels = n2_vec[samp_],cex=cex_,font=165,col=col_vec)
    }
    dev.off()
  }

  pdf("~/Downloads/PCVecs.pdf")
  {
    par(mar=c(5,5,1,1))
    CharEmbeds <- as.matrix(CharEmbeddingLayer$trainable_variables[[1]])
    CharEmbeds_pc_pred <- predict( CharEmbeds_pc <- prcomp(CharEmbeds) )
    CharLabels <- enc2utf8(c(charIndicators[,1]))
    CharEmbeds_pc_pred <- CharEmbeds_pc_pred[CharLabels %in% (char_pool <- c(letters)),]
    CharEmbeds <- CharEmbeds[CharLabels %in% char_pool,]
    CharLabels <- CharLabels[CharLabels %in% char_pool]
    cmat_char <- cor(t(CharEmbeds))
    row.names(cmat_char) <- colnames(cmat_char) <- CharLabels
    cmat_char <- cmat_char[order(row.names(cmat_char)),order(colnames(cmat_char))]
    #diag(cmat_char) <- 0
    corrplot::corrplot(cmat_char, type="full", tl.col="black",col.lim=c(-max(abs(cmat_char)),max(abs(cmat_char))),
                       is.corr=T,cl.cex = 0.65,diag=T)
    #plot(CharEmbeds_pc_pred,cex=0);text(CharEmbeds_pc_pred,labels=row.names(cmat_char))
  }
  dev.off()

  pdf("~/Downloads/PCPositions.pdf")
  {
    par(mfrow=c(1,2));par(mar=c(5,5,1,1))
    RelCharPos <- as.matrix(RelCharsPosEmbeddingLayer$trainable_variables[[1]])
    RelCharPos_pc_pred <- predict( RelCharPos_pc <- prcomp(RelCharPos) )[,1]

    RelWordPos <- as.matrix(RelWordPosEmbeddingLayer$trainable_variables[[1]])
    RelWordPos_pc_pred <- predict( RelWordPos_pc <- prcomp(RelWordPos) )[,1]
    RelWordPos_pc_pred <- RelWordPos_pc_pred[-length(RelWordPos_pc_pred)]

    plot( c(rev(RelCharPos_pc_pred[-c(1:(max_nCharsPerAlias))]),
            RelCharPos_pc_pred[1:(max_nCharsPerAlias)]))
    plot( c(rev(RelWordPos_pc_pred[-c(1:(max_nCharsPerAlias-1))]),
            RelWordPos_pc_pred[1:(max_nCharsPerAlias)]))
  }
  dev.off()
}

print2("String dist results...")
{
  stringDist_bestMatch <- sapply(PosMatches_mat_hold$name1,function(zer){
    which.min( stringdist::stringdist(zer,PosMatches_mat_hold$name2,
                                      method = "jaccard", q = 2))[1] })
  print2(  sprintf("String dist accuracy: %.3f",
                   mean(PosMatches_mat_hold$to1 == PosMatches_mat_hold$to2[stringDist_bestMatch])))
  AutopsyMat <- cbind(truth_, "ml"=PosMatches_mat_hold$name2[bestMatch_ml], "string"=PosMatches_mat_hold$name2[stringDist_bestMatch])
}

print2("Analyze ML model results...")
{
  # ml wrong, string right
  mean( PosMatches_mat_hold$to1 != PosMatches_mat_hold$to2[bestMatch_ml] &  PosMatches_mat_hold$to1 == PosMatches_mat_hold$to2[stringDist_bestMatch])
  #View( AutopsyMat[PosMatches_mat_hold$to1 != PosMatches_mat_hold$to2[bestMatch_ml] & PosMatches_mat_hold$to1 == PosMatches_mat_hold$to2[stringDist_bestMatch],] )

  # ml right, string wrong
  mean(PosMatches_mat_hold$to1 == PosMatches_mat_hold$to2[bestMatch_ml] &  PosMatches_mat_hold$to1 != PosMatches_mat_hold$to2[stringDist_bestMatch])
  #View( AutopsyMat[PosMatches_mat_hold$to1 == PosMatches_mat_hold$to2[bestMatch_ml] & PosMatches_mat_hold$to1 != PosMatches_mat_hold$to2[stringDist_bestMatch],] )

  #both wrong
  #View( AutopsyMat[PosMatches_mat_hold$to1 != PosMatches_mat_hold$to2[bestMatch_ml] & PosMatches_mat_hold$to1 != PosMatches_mat_hold$to2[stringDist_bestMatch],] )
}
