{
  # setup conda env
  library( reticulate )
  reticulate::use_condaenv(conda_env, required = T) 
  reticulate::use_condaenv(conda_env, required = T)

  # import packages
  #tf <- reticulate::import("tensorflow")
  py_gc <- reticulate::import("gc")
  np <- reticulate::import("numpy")
  optax <- reticulate::import("optax")
  eq <- reticulate::import("equinox")
  jmp <- import("jmp")
  jax <- reticulate::import("jax")
  jnp <- reticulate::import("jax.numpy")

  LinearizeNestedList <- function (NList, LinearizeDataFrames = FALSE, NameSep = "/",
                                   ForceNames = FALSE)
  {
    stopifnot(is.character(NameSep), length(NameSep) == 1)
    stopifnot(is.logical(LinearizeDataFrames), length(LinearizeDataFrames) ==
                1)
    stopifnot(is.logical(ForceNames), length(ForceNames) == 1)
    if (!is.list(NList))
      return(NList)
    if (is.null(names(NList)) | ForceNames == TRUE)
      names(NList) <- as.character(1:length(NList))
    if (is.data.frame(NList) & LinearizeDataFrames == FALSE)
      return(NList)
    if (is.data.frame(NList) & LinearizeDataFrames == TRUE)
      return(as.list(NList))
    A <- 1
    B <- length(NList)
    while (A <= B) {
      Element <- NList[[A]]
      EName <- names(NList)[A]
      if (is.list(Element)) {
        Before <- if (A == 1)
          NULL
        else NList[1:(A - 1)]
        After <- if (A == B)
          NULL
        else NList[(A + 1):B]
        if (is.data.frame(Element)) {
          if (LinearizeDataFrames == TRUE) {
            Jump <- length(Element)
            NList[[A]] <- NULL
            if (is.null(names(Element)) | ForceNames ==
                TRUE)
              names(Element) <- as.character(1:length(Element))
            Element <- as.list(Element)
            names(Element) <- paste(EName, names(Element),
                                    sep = NameSep)
            NList <- c(Before, Element, After)
          }
          Jump <- 1
        }
        else {
          NList[[A]] <- NULL
          if (is.null(names(Element)) | ForceNames == TRUE)
            names(Element) <- as.character(1:length(Element))
          Element <- LinearizeNestedList(Element, LinearizeDataFrames,
                                         NameSep, ForceNames)
          names(Element) <- paste(EName, names(Element),
                                  sep = NameSep)
          Jump <- length(Element)
          NList <- c(Before, Element, After)
        }
      }
      else { Jump <- 1 }
      A <- A + Jump
      B <- length(NList)
    }
    return(NList)
  }
}
