{
  # set important parameters
  {
    library(  fastmatch   )
    LEARNING_RATE_MAX <- 0.002; AdaptiveGradClipRatio <- 0.05 # LEARNING_RATE_MAX <- 0.001; AdaptiveGradClipRatio <- 0.05 gives 0.87
    nSGD_model <- nSGD_DefiningLRSeq <- 12000L  # 6000L
    adv_frac <-  0.50 # 0.5 generateas D of 0.86; 1 gives D of 0.75; 0 gives D of 0 .72
    batchSize_perGroup <- 64L # 64L gives D of 0.86 # batch size is really size of each pos/neg class
    batchSize_posPool <- batchSize_negPool <- (ai<-as.integer)(round(ifelse(adv_frac > 0,
                                                              yes = 6L*batchSize_perGroup*adv_frac,
                                                              no = batchSize_perGroup)))
    nNonAdversarial_neg <- nNonAdversarial_pos <- ai(round(batchSize_perGroup*(1-adv_frac)))
    nAdversarial_neg <- nAdversarial_pos <- ai(round(batchSize_perGroup*(adv_frac)))
    if(adv_frac < 1){ nNonAdversarial_neg <- nNonAdversarial_pos <- max(c(nNonAdversarial_pos,2L)) }

    # define pool size
    batchSize_pos_total <- nNonAdversarial_pos + batchSize_posPool
    batchSize_neg_total <- nNonAdversarial_neg + batchSize_negPool

    max_nWordsPerAlias <- 16L # 24L
    max_nCharsPerWord <- 32L # 48L
    max_nCharsPerAlias <- max_nCharsPerWord * max_nWordsPerAlias
    MaxUqWords_AdvSel <- ai( (2L * batchSize_posPool * max_nWordsPerAlias)*0.3 )
    MaxUqWords_Train <- ai( (2L * batchSize_perGroup * max_nWordsPerAlias)*0.3 )
    nWidth_ts <- nEmbedDim <- ai( 2^8.75 ) #   2^8 generates D of 0.865, 2^8.5 gets to 0.87
    nOutputWidth <- ai( 2^10 ) #  2^10 generates D of 0.865, 2^11 generates D of 0.875
    nHiddenDepth_word <- 2L #   2L generates D of 0.865
    nHiddenDepth_alias <- 8L #  8L generates D of 0.865
    TotalDepth <- nHiddenDepth_word + nHiddenDepth_alias
    WideMultiplicationFactor <- 3.75

    nTransformerHeads = 12L # 16L generates D of 0.865
    paddingType <- "valid"
    embeddingsType <- "rotary"
    transformerActivation <- "swiglu"
    ep_LabelSmooth <- jnp$array(0.02, jnp$float32)
  }

  # write key helper functions
  {
    if(!"charIndicators" %in% ls()){
      try( charIndicators <- as.matrix(data.table::fread(file = "./DataOutputs/charIndicators.csv")),T)
    }
    nchars <- nrow( charIndicators )
    charIndicators[,1] <- enc2utf8(charIndicators[,1])
    START_CODON_WORD_zi <- ai(nrow(charIndicators))
    STOP_CODON_WORD_zi <- ai(nrow(charIndicators)+1L)
    LAST_CODON_WORD_zi <- STOP_CODON_WORD_zi
    BASE_name2char_HOLDER <- rep(BLANK_CODON_WORD_zi <- -1L, times = max_nCharsPerWord)

    START_CODON_ALIAS_zi <- ai(nrow(charIndicators))
    STOP_CODON_ALIAS_zi <- ai(nrow(charIndicators)+1L)
    CLS_CODON_ALIAS_zi <- ai(nrow(charIndicators)+1L)

    BLANK_CODON_WORD_zi_tf <- jnp$array(BLANK_CODON_WORD_zi,jnp$int32)
    HASH_TABLE <- as.data.frame( cbind(1:length(HASH_TABLE <-c(letters,LETTERS,
                                                               1:(max_nCharsPerAlias-26*2)) ),HASH_TABLE) )
    pushWords <- function(names_){
      # push shorter sequence to be of max_nWords in word length
      sapply(names_, function(name_){
        tmp_ <- (strsplit(name_,split=" ")[[1]] )
        nWords_name_ <- length(tmp_)
        neededWords <- max_nWords - nWords_name_; add_ <- ""
        add_ <- c(); c_ <- 0
        if(length(tmp_) ==1 ){tmp_<- c(tmp_,tmp_)}
        tmp_rev <- paste(rev(tmp_)[-1],collapse=" ")
        tmp_ <- paste(tmp_[-1],collapse= " ")
        ok <- F; while(!ok){
          c_ <- c_ + 1 ; if(c_ %% 2 == 1){ add_ <- paste(add_, tmp_rev,sep = " ") }
          if(c_ %% 2 == 0){ add_ <- paste(add_, tmp_,sep =" ") }
          ok <- length(strsplit(add_,split=" ")[[1]]) > neededWords
        }
        final_ <- paste(name_, add_,sep= "")
        final_split <- strsplit(final_,split=" ")[[1]]
        if(length(final_split) < max_nWords){browser()}
        if(length(final_split) > max_nWords){final_ = paste(final_split[1:max_nWords],collapse=" ")}
        return(   final_    )
      },USE.NAMES = F)
    }
    pushSeq <- function(era, returnIndices = "seqPush1", maxSeqLen){
      # push shorter sequence to be of maxSeqLen in character length
      sapply(era,function(eraa){
        if(returnIndices %fin% c("wordPush","seqPush2") ){
          tmp__ <- HASH_TABLE[,2]
          if(returnIndices == "wordPush"){ eraa_split <- strsplit(eraa,split=" ")[[1]]
          eraa_split <- sapply(1:length(eraa_split),function(zer){
            paste(rep(tmp__[zer],times=nchar(eraa_split[zer])),collapse="") })
          eraa <- paste(eraa_split,collapse = " ")
          }
          if(returnIndices == "seqPush2"){ eraa_split <- strsplit(eraa,split="")[[1]]
          eraa_split <- sapply(1:length(eraa_split),function(zer){
            paste(rep(tmp__[zer],times=nchar(eraa_split[zer])),collapse="") })
          eraa <- paste(eraa_split,collapse = "")
          eraa <- paste(replicate(ceiling(max_nCharsPerAlias/nchar(eraa)),eraa),collapse="")
          eraa <- paste(strsplit(eraa,split="")[[1]][1:max_nCharsPerAlias],collapse="")
          }
        }

        nChars_eraa <- nchar(eraa)
        neededChars <- maxSeqLen - nChars_eraa; add_ <- ""
        pushType <- "repeat"
        if(neededChars>0 & pushType == "repeat"){
          eraa <- paste(replicate(ceiling(max_nCharsPerAlias/nchar(eraa)),eraa),collapse="")
          eraa <- paste(strsplit(eraa,split="")[[1]][1:max_nCharsPerAlias],collapse="")
        }
        if(neededChars>0 & pushType == "reflection"){
          if(T == T){ add_ <- c(); c_ <- 0
          tmp_ <- (strsplit(eraa,split=" ")[[1]] )
          if(length(tmp_) ==1 ){tmp_<- c(tmp_,tmp_)}
          tmp_rev <- paste(rev(tmp_)[-1],collapse=" ")
          tmp_ <- paste(tmp_[-1],collapse= " ")
          ok <- F; while(!ok){
            c_ <- c_ + 1
            if(c_ %% 2 == 1){ add_ <- paste(add_, tmp_rev,collapse = " ") }
            if(c_ %% 2 == 0){ add_ <- paste(add_, tmp_,sep =" ") }
            ok <- nchar(add_) >= neededChars
          }
          add_ <- c("", strsplit(paste(add_,collapse=" "),split="")[[1]][0:(neededChars)])
          } }
        final_ <- paste(eraa, paste(add_,collapse=""),sep="")
        if(nchar(final_) > maxSeqLen){final_ = substr(final_,start=0,stop=maxSeqLen)}
        return( final_ )
      } ) }
  }

  # character embedding - one vector for each character
  CharEmbeddings <- eq$nn$Embedding(embedding_size = nEmbedDim,
                                        num_embeddings = nchars+4L,
                                        key = jax$random$PRNGKey(240L))
  TransformerLists <- c(list(),list()); type_counter <- 0L; for(type in c("word", "alias")){
    type_counter <- type_counter + 1L
    nHiddenDepth_ts <- ifelse(type == "word", yes = nHiddenDepth_word, no = nHiddenDepth_alias)
    TransformerList <- replicate(nHiddenDepth_ts+1, list())
    for(l_ in 1L:nHiddenDepth_ts){
      TransformerList[[l_]][[1]] <- eq$nn$MultiheadAttention(
        query_size = nWidth_ts,
        output_size = nWidth_ts,
        num_heads = nTransformerHeads,
        use_output_bias = F,
        key = jax$random$PRNGKey( ai(323L + l_ + 40L*type_counter)))
      TransformerList[[l_]][[2]] <- jnp$array( t(rep(1,times=nWidth_ts) ) )
      if(transformerActivation != "swiglu"){
        # standard FFN
        TransformerList[[l_]][[3]] <- eq$nn$MLP(in_size = nWidth_ts,
                                                out_size = nWidth_ts,
                                                width_size = ai(nWidth_ts*WideMultiplicationFactor),
                                                depth = 1L, use_bias = T, use_final_bias = F,
                                                activation = JaxAct,
                                                key = jax$random$PRNGKey(ai(330L + l_ + 80L*type_counter)))
      }
      if(transformerActivation == "swiglu"){
        # swiglu FFN
        TransformerList[[l_]][[3]] <- list(eq$nn$Linear(in_features = nWidth_ts,
                                                        out_features = ai(nWidth_ts*WideMultiplicationFactor),
                                                        use_bias = F, # hidden bias
                                                        key = jax$random$PRNGKey(ai(3340L + l_+type_counter))),
                                           eq$nn$Linear(in_features = nWidth_ts,
                                                        out_features = ai(nWidth_ts*WideMultiplicationFactor),
                                                        use_bias = F, # swiglu bias
                                                        key = jax$random$PRNGKey(ai(3311L + l_+type_counter))),
                                           eq$nn$Linear(in_features = ai(nWidth_ts*WideMultiplicationFactor),
                                                        out_features = nWidth_ts,
                                                        use_bias = F, # final bias
                                                        key = jax$random$PRNGKey(ai(33324L + l_+type_counter))))
      }
      TransformerList[[l_]][[4]] <- jnp$array( t(rep(1,times=nWidth_ts) ))
    }
    # append CLS representation + final RMS weights
    TransformerList[[nHiddenDepth_ts+1]] <- list(
                                                 jnp$array(t(runif(nWidth_ts,-sqrt(6/nWidth_ts),sqrt(6/nWidth_ts)))), # Start (used for word)
                                                 jnp$array(t(runif(nWidth_ts,-sqrt(6/nWidth_ts),sqrt(6/nWidth_ts)))), # Stop (used for alas)
                                                 jnp$array(t(runif(nWidth_ts,-sqrt(6/nWidth_ts),sqrt(6/nWidth_ts)))), # Supplemental CLS (if used)
                                                 jnp$array(rep(1,times = nWidth_ts)),  # final RMS weighter
                                                 eq$nn$Linear(in_features = nWidth_ts, out_features = ifelse(type == "alias", yes = nOutputWidth, no = nWidth_ts),
                                                              use_bias = F, key = jax$random$PRNGKey(999L+type_counter) ) # final dense proj
                                                 )

    # append list to output list
    TransformerLists[[type_counter]] <- TransformerList; rm( TransformerList )
  }

  # define output fxns
  if(embeddingsType == "rotary"){
    # https://arxiv.org/pdf/2104.09864.pdf
    position <- jnp$expand_dims(jnp$arange(1L, max(c(max_nCharsPerWord, max_nWordsPerAlias))+3L), 1L)  # + 3L for CLS, stop, start
    theta_vals <-  10000^( -(2*( 1:(nWidth_ts/2) )) / nWidth_ts ) # p. 5
    theta_vals <- c(sapply(theta_vals,function(z){c(z,z)}))
    theta_vals <- jnp$expand_dims(jnp$array(theta_vals), 0L)
    cos_terms <- jnp$cos( pos_times_theta <- (position *  theta_vals) ) # p. 7
    sin_terms <- jnp$sin( pos_times_theta )
  }

  RMS_norm <- function(x_){ jnp$divide( x_, jnp$sqrt(0.001+jnp$mean(jnp$square(x_), -1L, keepdims=T))) }
  ffmap <- jax$vmap(function(L_, x){ L_(x) }, in_axes = list(NULL,0L))
  OneTSNetwork_batch <- jax$vmap( OneTSNetwork <- function(TransformerList, xt, StateList, MPList, inference, type){
    # initial casts
    cos_terms <- MPList[[1]]$cast_to_compute(cos_terms)
    sin_terms <- MPList[[1]]$cast_to_compute(sin_terms)

    nHiddenDepth_ts <- ifelse(type == "word", yes = nHiddenDepth_word, no = nHiddenDepth_alias)
    x_mask <- xt[[2]]; xt <- xt[[1]]

    if(embeddingsType == "vaswani2017"){
        xt <- jnp$add(xt, jnp$multiply( SoftPlus( InitProcessList[[1]] ), PE) ) # scale the position encodings
      }
    if(embeddingsType == "rotary"){  } # do nothing

    # append CLS representation at position D+1
    #x_mask <- jnp$concatenate(list(x_mask, jnp$ones(list(1L,1L))), 0L)
    #xt <- jnp$concatenate(list(xt, TransformerList[[nHiddenDepth_ts+1]][[1]]),axis = 0L)

    # if(type == "alias"){ browser() }
    # which( np$array(x_mask$val)[1,1:10,] == 1 ) # apple
    # np$array(xt$val)[1,1:10,1:5]

    if(type == "alias"){
        # start codon
        x_mask <- jnp$concatenate(list(jnp$ones(list(1L,1L)), x_mask), 0L)
        xt <- jnp$concatenate(list(TransformerList[[nHiddenDepth_ts+1]][[1]], xt),axis = 0L)

        # stop condon
        FirstNull_0i <- jnp$sum( x_mask )$astype(jnp$int32)
        x_mask <- x_mask$at[FirstNull_0i,]$set( jnp$array(( 1L ) ) )
        xt <- xt$at[FirstNull_0i,]$set( jnp$squeeze( TransformerList[[nHiddenDepth_ts+1]][[2]]) )
    }
    FirstNull_0i <- (jnp$sum(x_mask)$astype(jnp$int32) - 1L)
    # np$array(FirstNull_0i$val)

    # multihead attn part
    x_mask_attn <- jnp$multiply(x_mask, jnp$transpose(x_mask)) #length: (heads[opt], query_seq_length, kv_seq_length)
    x_mask_attn <- x_mask_attn$astype(jnp$bool_)
    x_mask_1oversums <- jnp$reciprocal( jnp$add(0.00001, jnp$sum(x_mask,0L,keepdims=T) ) )

    print2(sprintf("Starting Transformer block [depth %s; type %s]...", nHiddenDepth_ts, type))
    xtm1 <- xt; for(d_ in 1:nHiddenDepth_ts){
        # transformer block parameters
        TransformerList_d <- TransformerList[[d_]]

        # standardize
        xt <- jnp$multiply(RMS_norm(xt), TransformerList_d[[2]])

        # rotary embeddings
        if(embeddingsType == "rotary"){
          swapped_x <- jnp$zeros_like( xt )
          for( IDX in seq(0L, nWidth_ts, by = 2L)){
            swapped_x <- swapped_x$at[,jnp$array(IDX)]$add(  jnp$negative(jnp$take(xt, IDX+1L, axis = 1L) ) )
            swapped_x <- swapped_x$at[,jnp$array(IDX+1L)]$add( jnp$take(xt, IDX, axis = 1L) )
          }
          xt_pos <- xt*jnp$take(cos_terms, jnp$array(0L:(swapped_x$shape[[1]]-1L) ), 0L) +
                          swapped_x*jnp$take(sin_terms, jnp$array(0L:(swapped_x$shape[[1]]-1L) ), 0L)  # p. 7
        }

        # multihead attention block
        xt <- TransformerList_d[[1]](query = xt_pos,
                                     key_  = xt_pos,
                                     value = xt,
                                     mask  = x_mask_attn )

        # residual connection, see https://arxiv.org/abs/2302.00453
        xtm1 <- xt <- xtm1 + xt/sqrt(1.*TotalDepth)

        # normalize
        xt <- jnp$multiply(RMS_norm(xt), TransformerList_d[[4]])

        # feed forward
        if(transformerActivation != "swiglu"){ xt <- ffmap(  TransformerList_d[[3]], xt  )}  # standard FNN
        if(transformerActivation == "swiglu"){  # swiglu FFN
          xt <- jnp$multiply(
                  jax$nn$swish(ffmap(TransformerList_d[[3]][[1]], xt)),
                               ffmap(TransformerList_d[[3]][[2]], xt)) # swiglu proj
          xt <- ffmap(TransformerList_d[[3]][[3]], xt) # final proj
        }

        # residual connection to previous state, see https://arxiv.org/abs/2302.00453
        xtm1 <- xt <- xtm1 + xt/sqrt(1.*TotalDepth)
    }
    print2(sprintf("Done with Transformer block [depth %s; type %s]...", nHiddenDepth_ts, type))

    # checks
    # plot(np$array(jnp$take(xt, indices = 0L, axis = 0L) $val)[1:10,sample(1:20,2)])
    # if(type == "alias"){ browser() }; plot(  np$array( xt$val )[1,,1]); plot(  np$array( xt$val )[1,,2] )
    # plot( apply(np$array(RMS_norm( xt )$val)[1,,],1,function(zer){sqrt(mean(zer^2))}) )
    # which( np$array(x_mask$val)[1,,] == 1 )

    # if(type == "alias"){ browser() }
    #xt <- jnp$multiply(jnp$sum( xt <- jnp$multiply(xt, x_mask), axis = 0L), jnp$squeeze(x_mask_1oversums)) # channel means
    # xt <- jnp$take(xt, indices = xt$aval$shape[[1]]-1L, axis = 0L) # CLS embedding state if using last
    # xt <- jnp$take(xt, indices = FirstNull_0i, axis = 0L) # CLS embedding state if using last non-masked
    #if(type == "word"){  xt <- jnp$multiply(jnp$sum( xt <- jnp$multiply(xt, x_mask), axis = 0L), jnp$squeeze(x_mask_1oversums))  }
    #if(type == "alias"){  xt <- jnp$take(xt, indices = 0L, axis = 0L) } # CLS embedding state if using first
    xt <- jnp$take(xt, indices = 0L, axis = 0L)

    # normalize and get output - experiment with just doing with alias
    if(type == "alias"){
      xt <- jnp$squeeze(jnp$multiply( RMS_norm( jnp$expand_dims(xt,0L) ), TransformerList[[nHiddenDepth_ts+1]][[4]]  ))
    }

    # linear & output
    if(type == "alias"){ # 0.86 just doing this with alias transformer
      xt <-  TransformerList[[nHiddenDepth_ts+1]][[5]]( xt )
    }

    # plot(np$array( xt$val )[,sample(1:100,2)])
    # plot( apply(np$array( xt$val ), 1, sd))
    # plot( apply(np$array( xt$val ), 1, function(zer){sqrt(mean(zer^2))}) )

    # batchnorm the output
    # return_x <- BNList[[1]][[1]](return_x, state = StateList[[1]][[1]], inference = inference);
    # StateList[[1]][[1]] <- return_x[[2]]; return_x <- return_x[[1]]
    # return_x <- BNList[[1]][[2]]( return_x )

    return( list(xt, StateList ) )
  },
  list(NULL, 0L, NULL, NULL, NULL, NULL), out_axes = list(0L,NULL))

  GetAliasRepresentation_jit <- eq$filter_jit( GetAliasRepresentation <- function(ModelList, xt, StateList, MPList, inference){
    CINDICES <- xt[[1]]; cmask <- jnp$expand_dims(jnp$not_equal(CINDICES, -1L),2L)
    WINDICES <- xt[[2]]; wmask <- jnp$expand_dims(jnp$not_equal(WINDICES, -1L),2L)

    # character model (embedding)
    xt <- jax$vmap(jax$vmap(function(x){ModelList[[MLKey["CharEmbeddings"]]](x)},0L), 1L, 1L)( CINDICES )
    # hist( np$array(xt)[1,1:10,1:10])

    # word model (transformer 1)
    xt <- OneTSNetwork_batch(ModelList[[MLKey["TransformerLists"]]][[1]],
                             list(xt,  cmask),
                             StateList, MPList, inference, "word")
    StateList <- xt[[2]]; xt <- xt[[1]]
    # plot( np$array(xt)[1:10,sample(1:100,2)] )

    # alias model (transformer 2)
    xt <- jnp$take(xt, WINDICES, 0L)
    xt <- OneTSNetwork_batch(ModelList[[MLKey["TransformerLists"]]][[2]],
                             list(xt, wmask),
                             StateList, MPList, inference, "alias")
    StateList <- xt[[2]]; xt <- xt[[1]]

    # cast to output
    xt <- MPList[[1]]$cast_to_output( xt )

    return( list(xt, StateList)  )
  })
  FinalDenseList <- eq$nn$Linear(in_features = 1L, out_features = 1L, key = jax$random$PRNGKey(40004L))
  FinalDenseList <- eq$tree_at( function(l){l$weight}, FinalDenseList, jnp$array(as.matrix(-1) ))
  MLKey <- c("CharEmbeddings" = 1, "TransformerLists" = 2, "FinalDenseList" = 3)
  ModelList <- list(CharEmbeddings, TransformerLists, FinalDenseList); rm(list=names(MLKey))
  StateList <- list( jnp$array(0.) )
  MPList <- list(jmp$Policy(compute_dtype = (computeDtype <- jnp$float16),
                            param_dtype = jnp$float32,
                            output_dtype = jnp$float32 ),
                 jmp$DynamicLossScale(loss_scale = jnp$array(2^15,dtype = jnp$float16),
                                      min_loss_scale = jnp$array(1.,dtype = jnp$float16),
                                      period = 20L))


  GetMatchProb_jit <- eq$filter_jit( GetMatchProb <- function(ModelList, xt, StateList, MPList, inference){
    # cast to compute dtype
    ModelList <- MPList[[1]]$cast_to_compute(  ModelList  )

    # partition alias representations using WINDICES housed in 2's list entry of xt
    half_range <- jnp$arange( half_is <- ai( (xt[[2]])$shape[[1]] / 2L ) )

    # get alias representation
    xt <- GetAliasRepresentation(ModelList, xt, StateList, MPList, inference)
    StateList <- xt[[2]]; xt <- xt[[1]]

    # compute distances
    xt <- jnp$sqrt( jnp$add(0.01^2, jnp$mean(jnp$square(jnp$subtract(
      jnp$take(xt, half_range, axis = 0L), # rep 1
      jnp$take(xt, jnp$add(half_is, half_range), axis = 0L) # rep 2
    )),1L,keepdims=T)) )

    xt <- jax$nn$sigmoid( ffmap(ModelList[[MLKey["FinalDenseList"]]], xt  ) )
    return(  list(xt, StateList) )
  }  )

  GetLoss <-  function(ModelList, xt, truth, StateList, MPList, inference){
    # cast to compute
    ModelList <- MPList[[1]]$cast_to_compute(  ModelList  )
    ep_LabelSmooth <- MPList[[1]]$cast_to_compute(  ep_LabelSmooth )
    #truth <- MPList[[1]]$cast_to_compute(  truth  )

    # get predicted prob
    #xt <- GetMatchProb(ModelList, xt, StateList, MPList, inference)
    #StateList <- xt[[2]]; xt <- xt[[1]]

    half_range <- jnp$arange( half_is <- ai( (xt[[2]])$shape[[1]] / 2L ) )
    xt <- GetAliasRepresentation(ModelList, xt, StateList, MPList, inference)
    StateList <- xt[[2]]; xt <- xt[[1]]

    # compute dist
    dist <- jnp$sqrt( jnp$add(0.005, jnp$mean(jnp$square(
      jnp$take(xt, half_range, axis = 0L) -
        jnp$take(xt, jnp$add(half_is, half_range), axis = 0L) # rep 2
    ),1L,keepdims=T)) )
    prob <- jax$nn$sigmoid( ffmap(ModelList[[MLKey["FinalDenseList"]]], dist  ) )

    if(T == F){
      # grid
      myGrid_add <- expand.grid(1L:(xt$shape[[1]]), 1L:(xt$shape[[1]]))
      myGrid_add <- myGrid_add[ !(myGrid_add[,2] ==  (myGrid_add[,1]+xt$shape[[1]]/2)),]
      myGrid_add <- myGrid_add[ !(myGrid_add[,1] ==  (myGrid_add[,2]+xt$shape[[1]]/2)),]
      myGrid_add <- t(apply(myGrid_add,1,sort))
      myGrid_add <- myGrid_add[!duplicated(apply(myGrid_add,1,function(zer){paste(zer,collapse = "_")})),]
      myGrid_add <- myGrid_add[myGrid_add[,1] != myGrid_add[,2],]
      # myGrid_add; cbind(np$array(half_range),np$array(half_is+half_range))+1L
      myGrid_add <- myGrid_add - 1L
      myGrid_c1 <- jnp$array(myGrid_add[,1])
      myGrid_c2 <- jnp$array(myGrid_add[,2])

      # compute distances
      dist2 <- jnp$sqrt( jnp$add(0.01^2, jnp$mean(jnp$square(
        jnp$take(xt, myGrid_c1, axis = 0L) -
          jnp$take(xt, myGrid_c2, axis = 0L) # rep 2
      ),1L,keepdims=T)) )
      p2 <- jax$nn$sigmoid( ffmap(ModelList[[MLKey["FinalDenseList"]]], dist2  ) )

      # concatenate
      prob <- jnp$concatenate( list(prob, p2), 0L)
      truth <- jnp$concatenate( list(truth, jnp$zeros_like(p2)), 0L)
    }

    #label smoothing
    truth <- jnp$add(jnp$multiply(jnp$subtract(1., ep_LabelSmooth),truth), jnp$divide(ep_LabelSmooth,2.))

    # kl divergence
    minThis <- jnp$mean( jnp$add(
        jnp$multiply(truth, jnp$subtract(jnp$log( truth ), jnp$log( prob )  )),
        jnp$multiply(jnp$subtract(1., truth),
                    jnp$subtract(jnp$log( jnp$subtract(1., truth) ),
                                 jnp$log( jnp$subtract(1., prob) )  ))), 0L)
    minThis <- jnp$squeeze(minThis, 0L)

    # cast to output
    minThis <- MPList[[1]]$cast_to_output(  minThis  )
    if( as.character(  computeDtype$dtype ) == "float16"){
      minThis <- MPList[[2]]$scale( minThis ) # scale loss
    }

    return( list(minThis, StateList) )
  }
  GradAndLossAndAux <-  eq$filter_jit( eq$filter_value_and_grad( GetLoss, has_aux = T) )
  GetMatchProb_BigBatch <- function(name1, name2, nBatch_BigBatch = 50){
    batchSeq <- cumsum(1:length(name1) %% (nBatch_BigBatch) == 1)
    MatchProbMat <- tapply(1:length(batchSeq), batchSeq, function(batch_){
      # batch_ <- which(batchSeq == batchSeq[1]); inference <- T
      print( max(batch_) / length(batchSeq)  )
      xt <- GetList(name_raw = c(name1[batch_], name2[batch_]),
                    MaxUqWords = nBatch_BigBatch * max_nWordsPerAlias,
                    MaxUqAliases = 2L*nBatch_BigBatch)
      Probs <- c(np$array( GetMatchProb_jit(ModelList, xt, StateList, MPList, T)[[1]] )[1:length(batch_),])
      return(  Probs  )
    })
    MatchProbMat <- do.call(c, MatchProbMat)
    MatchProbMat <- as.data.frame(  cbind(name1, name2,  MatchProbMat) )
    MatchProbMat[,3] <- f2n(MatchProbMat[,3])
    colnames(MatchProbMat) <- c("name1","name2","matchprob")
    return( MatchProbMat )
  }
  GetAliasRep_BigBatch <- function(name1, nBatch_BigBatch = 64L){
    batchSeq <- cumsum(1:length(name1) %% (nBatch_BigBatch) == 1)
    print2("Fraction complete, GetAliasRep_BigBatch() call:")
    RepMat <- tapply(1:length(batchSeq), batchSeq, function(batch_){
      print2( max(batch_) / length(batchSeq)  )
      xt <- GetList(name_raw = c(name1[batch_]),
                    MaxUqWords = nBatch_BigBatch * max_nWordsPerAlias,
                    MaxUqAliases = 2L*nBatch_BigBatch)
      Rep_ <- np$array( GetAliasRepresentation_jit(ModelList,
                                                   xt,
                                                   StateList, MPList, T)[[1]] )[1:length(batch_),]
      return(  Rep_  )
    })
    RepMat <- do.call(rbind, RepMat)
    return( RepMat )
  }
}

